/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.util.Pair;
import com.zoyi.channel.plugin.android.deserializer.AnyMapDeserializer;
import com.zoyi.channel.plugin.android.deserializer.MessageDeserializer;
import com.zoyi.channel.plugin.android.deserializer.NestedMessageDeserializer;
import com.zoyi.channel.plugin.android.deserializer.TranslationRepoDeserializer;
import com.zoyi.channel.plugin.android.model.repo.TranslationRepo;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.NestedMessage;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.com.annimon.stream.Collectors;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.GsonBuilder;
import com.zoyi.com.google.gson.JsonElement;
import com.zoyi.com.google.gson.JsonPrimitive;
import com.zoyi.com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.util.Map;

public class ParseUtils {
    @Nullable
    private static Gson gson;

    public static Gson getCustomGson() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(Map.class, (Object)new AnyMapDeserializer());
            builder.registerTypeAdapter(Message.class, (Object)new MessageDeserializer());
            builder.registerTypeAdapter(NestedMessage.class, (Object)new NestedMessageDeserializer());
            builder.registerTypeAdapter(TranslationRepo.class, (Object)new TranslationRepoDeserializer());
            gson = builder.create();
        }
        return gson;
    }

    @Nullable
    public static <T> T parseJson(String entity, Class<T> target) {
        try {
            return (T)ParseUtils.getCustomGson().fromJson(entity, target);
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
            return null;
        }
    }

    @Nullable
    public static String parsePhoneNumber(Context context, @Nullable String phoneNumber) {
        try {
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            Integer simCountryCode = (Integer)Optional.ofNullable((Object)context.getSystemService("phone")).map(service -> (TelephonyManager)service).map(TelephonyManager::getSimCountryIso).map(String::toUpperCase).map(arg_0 -> ((PhoneNumberUtil)phoneNumberUtil).getCountryCodeForRegion(arg_0)).filter(it -> it != 0).orElse(null);
            return (String)Optional.ofNullable((Object)phoneNumberUtil.parse((CharSequence)phoneNumber, "ZZ")).filter(number -> number.hasCountryCode() && simCountryCode != null && number.getCountryCode() == simCountryCode.intValue()).map(number -> phoneNumberUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.NATIONAL)).orElse((Object)phoneNumber);
        }
        catch (Exception ex) {
            return phoneNumber;
        }
    }

    @Nullable
    public static Object parseJsonElement(JsonElement json) {
        try {
            if (json.isJsonArray()) {
                return Stream.ofNullable((Iterable)json.getAsJsonArray()).map(ParseUtils::parseJsonElement).collect(Collectors.toList());
            }
            if (json.isJsonObject()) {
                return Stream.ofNullable((Iterable)json.getAsJsonObject().entrySet()).map(entry -> new Pair((Object)((String)entry.getKey()), ParseUtils.parseJsonElement((JsonElement)entry.getValue()))).collect(Collectors.toMap(pair -> (String)pair.first, pair -> pair.second));
            }
            if (json.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
                if (jsonPrimitive.isBoolean()) {
                    return jsonPrimitive.getAsBoolean();
                }
                if (jsonPrimitive.isString()) {
                    return jsonPrimitive.getAsString();
                }
                if (jsonPrimitive.isNumber()) {
                    Long tryLong = ParseUtils.parseLong(jsonPrimitive.getAsString());
                    if (tryLong != null) {
                        return tryLong;
                    }
                    return jsonPrimitive.getAsDouble();
                }
                return null;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static Long parseLong(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        try {
            String[] split = object.toString().split("\\.");
            if (split.length == 1) {
                return Long.valueOf(split[0]);
            }
            if (split.length == 2) {
                for (int i = 0; i < split[1].length(); ++i) {
                    if (split[1].charAt(i) == '0') continue;
                    return null;
                }
                return Long.valueOf(split[0]);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static Object parseNumber(@Nullable String string2) {
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                try {
                    return Double.parseDouble(string2);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

