package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.store.binder.*;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;

public class ChannelSelector {

  public static Binder bindChannel(Action1<Channel> action1) {
    State<Channel> channelState = ChannelStore.get().channelState;

    return new Binder1<>(channelState).bind(channel -> {
      if (channel != null) {
        action1.call(channel);
      }
    });
  }

  public static Binder bindDisableStartChat(Action1<Boolean> action1) {
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Long> nowState = TimerStore.get().now;
    State<SupportBotEntry> supportBotState = SupportBotStore.get().supportBotState;

    return new Binder3<>(channelState, nowState, supportBotState).bind((channel, now, supportBot) -> {
      if (channel == null) {
        action1.call(true);
      } else {
        action1.call(
            !ChannelUtils.isWorking(channel, now) &&
                CompareUtils.exists(channel.getAwayOption(), Const.AWAY_OPTION_DISABLED, Const.AWAY_OPTION_HIDDEN) &&
                supportBot == null
        );
      }
    });
  }

  public static Binder bindAcceptInput(Action1<Boolean> action1) {
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Long> nowState = TimerStore.get().now;
    BooleanState typingState = TypingStore.get().typingState;

    return new Binder3<>(channelState, nowState, typingState).bind((channel, now, isTyping) -> {
      action1.call(shouldAcceptAction(channel, now, isTyping));
    });
  }

  static boolean shouldAcceptAction(@Nullable Channel channel, @Nullable Long now, Boolean isTyping) {
    if (isTyping != null && isTyping) {
      return true;
    } else if (channel != null && now != null) {
      return Const.AWAY_OPTION_ACTIVE.equals(channel.getAwayOption()) || ChannelUtils.isWorking(channel, now);
    }
    return false;
  }
}
