package com.zoyi.channel.plugin.android.activity.video;

import android.graphics.Color;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.widget.ImageButton;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.com.google.android.exoplayer2.DefaultRenderersFactory;
import com.zoyi.com.google.android.exoplayer2.ExoPlayerFactory;
import com.zoyi.com.google.android.exoplayer2.SimpleExoPlayer;
import com.zoyi.com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.zoyi.com.google.android.exoplayer2.source.MediaSource;
import com.zoyi.com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelector;
import com.zoyi.com.google.android.exoplayer2.ui.PlayerView;
import com.zoyi.com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.zoyi.com.google.android.exoplayer2.upstream.DataSource;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.zoyi.com.google.android.exoplayer2.util.Util;

public class VideoViewerActivity extends BaseActivity2 {

  private PlayerView videoPlayerView;
  private ImageButton downloadButton;

  @Nullable
  private SimpleExoPlayer exoPlayer;

  private String url;
  private String fileName;

  private long lastPosition;
  private boolean playWhenReady = true;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_video_viewer, Color.BLACK, false);

    url = getIntent().getStringExtra(Const.EXTRA_URL);
    fileName = getIntent().getStringExtra(Const.EXTRA_FILE_NAME);
    lastPosition = getIntent().getLongExtra(Const.EXTRA_START_AT, 0L);

    videoPlayerView = findViewById(R.id.ch_viewVideoPlayer);
    downloadButton = findViewById(R.id.exo_download);

    if (url != null && fileName != null) {
      downloadButton.setOnClickListener(v ->
          IntentUtils.setNextActivity(VideoViewerActivity.this, DownloadActivity.class)
              .putExtra(Const.EXTRA_URL, url)
              .putExtra(Const.EXTRA_FILE_NAME, fileName)
              .putExtra(Const.EXTRA_IMAGE, false)
              .setTransition(Transition.NONE)
              .startActivity()
      );

      BandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
      TrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory(bandwidthMeter);
      TrackSelector trackSelector = new DefaultTrackSelector(videoTrackSelectionFactory);

      exoPlayer = ExoPlayerFactory.newSimpleInstance(this, new DefaultRenderersFactory(this), trackSelector);
      videoPlayerView.setPlayer(exoPlayer);

      DataSource.Factory dataSourceFactory = new DefaultDataSourceFactory(this, Util.getUserAgent(this, "ChannelTalkSDK"));

      MediaSource videoSource = new ExtractorMediaSource.Factory(dataSourceFactory).createMediaSource(Uri.parse(url));
      exoPlayer.prepare(videoSource);
    } else {
      return false;
    }

    return true;
  }

  @Override
  protected void onStart() {
    super.onStart();

    if (exoPlayer != null) {
      exoPlayer.seekTo(lastPosition);
      exoPlayer.setPlayWhenReady(playWhenReady);
    }
  }

  @Override
  protected void onStop() {
    super.onStop();

    if (exoPlayer != null) {
      lastPosition = exoPlayer.getCurrentPosition();
      playWhenReady = exoPlayer.getPlayWhenReady();

      exoPlayer.setPlayWhenReady(false);
    }
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();

    if (exoPlayer != null) {
      exoPlayer.release();
      exoPlayer = null;
    }
  }
}
