package com.zoyi.channel.plugin.android.activity.lounge;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.action.*;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeAdapterContract;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.rest.AppMessenger;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.*;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class LoungePresenter
    extends AbstractAdapterPresenter<LoungeContract.View, LoungeAdapterContract.View, LoungeAdapterContract.Model>
    implements LoungeContract.Presenter {

  @Nullable
  private String topActivityName;

  public LoungePresenter(
      LoungeContract.View view,
      LoungeAdapterContract.View adapterView,
      LoungeAdapterContract.Model adapterModel,
      @Nullable String topActivityName
  ) {
    super(view, adapterView, adapterModel);
    this.topActivityName = topActivityName;
  }

  // Fetch methods

  @Override
  public void fetchBundleData() {
    fetchPreviewData();
  }

  @Override
  public void fetchPreviewData() {
    fetchLoungeData();
  }

  private void fetchUserChats(boolean showClosedChats) {
    UserChatAction.fetchUserChats(showClosedChats);
  }

  private void fetchLoungeData() {
    Plugin plugin = PluginStore.get().pluginState.get();

    if (plugin != null) {
      LoungeAction.fetchLounge(plugin.getId(), topActivityName);
    }
  }

  // bind

  @Override
  public void init() {
    if (SocketStore.get().socketState.get() != SocketStatus.READY) {
      view.onPreviewStateChange(PreviewState.FAILED);
    }

    bind(LoungeSelector.bindPreviewState(previewState -> view.onPreviewStateChange(previewState)));

    bind(ProfileSelector.bindDefaultProfile(profile -> view.onDefaultProfileChange(profile)));

    bind(LoungeSelector.bindWelcomeMessage(plaintText -> view.onWelcomeMessageChange(plaintText)));

    bind(SettingsSelector.bindShowClosedChats(showClosedChats -> {
      if (showClosedChats != null) {
        fetchUserChats(showClosedChats);
      }
    }));

    bind(ChatsSelector.bindChats((activeChatItems, closedChatItems) -> adapterModel.updateChatItems(activeChatItems)));

    bind(SocketSelector.bindSocket(socketStatus -> {
      if (socketStatus == SocketStatus.READY) {
        fetchBundleData();
      }
    }));
  }

  @Override
  public void removeChat(ChatItem item) {
    if (item instanceof UserChatItem) {
      view.showProgress(ResUtils.getString("ch.chat.delete_progress"));

      ChatAction.removeUserChat(
          item.getId(),
          (userChatRepo) -> {
            view.hideProgress();
            userChatRepo.remove();
            UserChatStore.get().userChats.removeByKey(item.getId());
          },
          () -> view.hideProgress()
      );
    }
  }

  @Override
  public void fetchConnect(AppMessenger appMessenger) {
    AppMessengerAction.fetchConnect(appMessenger.getName());
  }
}
