package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.*;
import android.widget.*;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnLinkButtonActionListener;
import com.zoyi.channel.plugin.android.enumerate.ButtonTheme;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.model.rest.Button;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.layout.BorderBackgroundView;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.channel.plugin.android.view.layout.message.TextMessageView;
import com.zoyi.com.annimon.stream.Stream;

import java.util.List;

public abstract class AbsMessageTextView extends LinearLayout {

  private BorderBackgroundView backHead;
  private BorderBackgroundView backContext;
  private ChBorderLayout layoutMessage;
  private TextMessageView textMessage;
  private LinearLayout layoutLinkButtons;
  private TextView textDelete;

  @Nullable
  private OnLinkButtonActionListener listener;

  public AbsMessageTextView(Context context) {
    super(context);
    init(context);
  }

  public AbsMessageTextView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public AbsMessageTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(getLayoutId(), this, true);

    backHead = view.findViewById(R.id.ch_viewMessageHolderHeadBorder);
    backContext = view.findViewById(R.id.ch_viewMessageHolderContextBorder);
    layoutMessage = view.findViewById(R.id.ch_layoutMessageHolder);
    layoutLinkButtons = view.findViewById(R.id.ch_layoutMessageHolderLinkButtons);
    textMessage = view.findViewById(R.id.ch_textMessageHolder);
    textDelete = view.findViewById(R.id.ch_textMessageHolderDelete);
  }

  public void setLinkButtonActionListener(OnLinkButtonActionListener listener) {
    this.listener = listener;
  }

  public void setHead(boolean isHead) {
    Views.setVisibility(backHead, isHead);
    Views.setVisibility(backContext, !isHead);
  }

  public void setText(@NonNull CharSequence text) {
    textMessage.setVisibility(View.VISIBLE);
    textMessage.setText(text);
  }

  public void setBlocks(@NonNull List<Block> blocks) {
    textMessage.setVisibility(View.VISIBLE);
    textMessage.setBlocks(blocks);
  }

  public void setLinkButtons(@NonNull List<Button> buttons) {
    if (layoutMessage != null) {
      try {
        ViewGroup.LayoutParams lp = layoutMessage.getLayoutParams();
        lp.width = LayoutParams.MATCH_PARENT;
        layoutMessage.setLayoutParams(lp);
      } catch (Exception e) {
      }
    }

    layoutLinkButtons.setVisibility(View.VISIBLE);
    Stream.of(buttons).forEach(button -> {
      MessageLinkButtonView linkButtonView = new MessageLinkButtonView(this.getContext());

      linkButtonView.setText(button.getTitle());
      if (button.getTheme() != null) {
        linkButtonView.setMessageTheme(ButtonTheme.fromString(button.getTheme()));
      }
      linkButtonView.setOnClickListener(v -> {
        if (listener != null) {
          this.listener.onLinkButtonClick(button.getUrl());
        }
      });

      layoutLinkButtons.addView(linkButtonView);
    });
  }

  public void setDelete() {
    textDelete.setVisibility(View.VISIBLE);
  }

  public void initViews() {
    setVisibility(View.GONE);

    if (layoutMessage != null) {
      try {
        ViewGroup.LayoutParams lp = layoutMessage.getLayoutParams();
        lp.width = LayoutParams.WRAP_CONTENT;
        layoutMessage.setLayoutParams(lp);
      } catch (Exception e) {
      }
    }

    if (textMessage != null) {
      textMessage.setVisibility(View.GONE);
    }
    if (layoutLinkButtons != null) {
      resetLinkButtons();
    }
    if (textDelete != null) {
      textDelete.setVisibility(View.GONE);
    }
  }

  private void resetLinkButtons() {
    if (layoutLinkButtons != null) {
      layoutLinkButtons.setVisibility(View.GONE);
      layoutLinkButtons.removeAllViews();
    }
  }

  protected void setBackColor(int backColor) {
    backHead.setColor(backColor);
    backContext.setColor(backColor);
    layoutMessage.setBackColor(backColor);
    layoutMessage.setBorderColor(backColor);
  }

  abstract protected int getLayoutId();
}
