package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;

/**
 * Created by mika on 2016. 2. 2..
 */
public class AvatarLayout extends ProfileLayout {

  private MaskableFrameLayout layoutAvatar;
  private View border;

  private int borderSize = 0;
  @ColorInt private int borderColor = Color.WHITE;

  public AvatarLayout(Context context) {
    super(context);
    init(context, null);
  }

  public AvatarLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
    init(context, attrs);
  }

  @Initializer
  protected void init(Context context, @Nullable AttributeSet attrs) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_avatar, this);
    super.init(context, root, attrs);

    layoutAvatar = root.findViewById(R.id.ch_layoutAvatar);
    border = root.findViewById(R.id.ch_borderAvatar);

    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.ProfileLayout,
          0,
          0);

      try {
        borderSize = typedArray.getDimensionPixelSize(R.styleable.ProfileLayout_ch_border_size, borderSize);
        borderColor = typedArray.getInt(R.styleable.ProfileLayout_ch_border_color, borderColor);
      } finally {
        typedArray.recycle();
      }
    }
    setBorder();
  }

  private void setBorder() {
    if (borderSize > 0) {
      FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) layoutAvatar.getLayoutParams();
      params.setMargins(borderSize, borderSize, borderSize, borderSize);
      layoutAvatar.setLayoutParams(params);

      border.getBackground().setColorFilter(borderColor, PorterDuff.Mode.SRC_ATOP);
      border.setVisibility(View.VISIBLE);
    } else {
      border.setVisibility(View.GONE);
    }
  }

  public void setBorderSize(int borderSize) {
    setBorder(borderSize, this.borderColor);
  }

  public void setBorderColor(@ColorInt int borderColor) {
    setBorder(this.borderSize, borderColor);
  }

  public void setBorder(int borderSize, @ColorInt int borderColor) {
    this.borderSize = borderSize;
    this.borderColor = borderColor;
    setBorder();
  }
}
