package com.zoyi.channel.plugin.android.model.etc;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;

public class FileMetaImpl implements FileMeta {

  private String id;
  private String url;
  private String name;

  public FileMetaImpl(String id, String url, String name) {
    this.id = id;
    this.url = url;
    this.name = name;
  }

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getUrl() {
    return url;
  }

  @Override
  public String getName() {
    return name;
  }

  @Nullable
  public static FileMeta getFileMeta(@Nullable String id, @Nullable String url, @Nullable String name) {
    if (id != null && url != null && name != null) {
      return new FileMetaImpl(id, url, name);
    }
    return null;
  }
}
