/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.com.annimon.stream.Optional;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssetUtils {
    private static final String EMOJI_FILE = "emojis.min.json";
    private static final String EXTENSIONS_FILE = "extensions.json";
    private static Map<String, String> emojiMap;
    private static Map<String, String> extensionMap;
    private static final String KEY_EMOJI_NAME = "n";
    private static final String KEY_EMOJI_CONTENT = "c";
    private static final String KEY_EXTENSION_KEY = "key";
    private static final String KEY_EXTENSION_LIST = "extensions";
    private static final String DEFAULT_FILE_KEY = "file";

    public static String getEmoji(Context context, String key) {
        if (emojiMap != null) {
            return emojiMap.get(key);
        }
        emojiMap = new ConcurrentHashMap<String, String>();
        try {
            InputStream inputStream = context.getAssets().open(EMOJI_FILE);
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            inputStream.close();
            JSONObject emojiJson = new JSONObject(new String(buffer, "UTF-8"));
            Iterator emojiKeys = emojiJson.keys();
            while (emojiKeys.hasNext()) {
                String category = (String)emojiKeys.next();
                JSONArray emojiCategory = emojiJson.getJSONArray(category);
                for (int i = 0; i < emojiCategory.length(); ++i) {
                    String emojiKey = emojiCategory.getJSONObject(i).getString(KEY_EMOJI_NAME);
                    String emojiValue = emojiCategory.getJSONObject(i).getString(KEY_EMOJI_CONTENT);
                    if (emojiKey == null || emojiValue == null) continue;
                    emojiMap.put(emojiKey, emojiValue);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return emojiMap.get(key);
    }

    @NonNull
    public static String getIconUrl(Context context, @Nullable String extension) {
        if (extensionMap == null) {
            extensionMap = new HashMap<String, String>();
            try {
                InputStream inputStream = context.getAssets().open(EXTENSIONS_FILE);
                int size = inputStream.available();
                byte[] buffer = new byte[size];
                inputStream.read(buffer);
                inputStream.close();
                JSONArray extensionList = new JSONArray(new String(buffer, "UTF-8"));
                for (int i = 0; i < extensionList.length(); ++i) {
                    JSONObject extensionData = extensionList.getJSONObject(i);
                    String extensionKey = extensionData.getString(KEY_EXTENSION_KEY);
                    JSONArray extensionArray = extensionData.getJSONArray(KEY_EXTENSION_LIST);
                    for (int j = 0; j < extensionArray.length(); ++j) {
                        extensionMap.put(extensionArray.getString(j), extensionKey);
                    }
                }
            }
            catch (Exception inputStream) {
                // empty catch block
            }
        }
        String iconPath = String.format("asset/file-icon/images/%s@2x.png", Optional.ofNullable(extensionMap).map(map -> (String)map.get(extension)).filter(it -> !it.isEmpty()).orElse((Object)DEFAULT_FILE_KEY));
        return String.format("%s/%s", UriUtils.getCloudFrontUrl(), iconPath);
    }
}

