/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.action.CountryAction;
import com.zoyi.channel.plugin.android.action.SupportBotAction;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.activity.chat.contract.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat.contract.ChatContract;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManagerInterface;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendActionItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendTextItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.RxBus;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ChatSelector;
import com.zoyi.channel.plugin.android.selector.ProfileBotSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.selector.SocketSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.ChatStore;
import com.zoyi.channel.plugin.android.store.CountryStore;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.store.TypingStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action3;
import com.zoyi.rx.functions.Action5;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChatPresenter
extends AbstractAdapterPresenter<ChatContract.View, ChatAdapterContract.View, ChatAdapterContract.Model>
implements ChatContract.Presenter,
MessageSendListener {
    private ChatContentType contentType;
    @Nullable
    private String contentId;
    @Nullable
    private Binder welcomeBinder;
    @Nullable
    private Binder welcomeAcceptInputBinder;
    @Nullable
    private Subscription joinSubscription;
    @Nullable
    private Subscription messageSubscription;
    @Nullable
    private Session lastReadSession;
    @Nullable
    private List<SendItem> tempItems;
    private List<Message> queueItems = new ArrayList<Message>();
    @Nullable
    private String backwardId;
    private boolean init = false;

    public ChatPresenter(ChatContract.View view, ChatAdapterContract.View adapterView, ChatAdapterContract.Model adapterModel, ChatContentType contentType, @Nullable String contentId) {
        super(view, adapterView, adapterModel);
        TimeUtils.refreshOffset();
        this.contentType = contentType;
        this.contentId = contentId;
    }

    private ChatManagerInterface getChatManager() {
        return ChatManager.get(this.contentType == ChatContentType.USER_CHAT ? this.contentId : null);
    }

    @Override
    public void init() {
        switch (this.contentType) {
            case USER_CHAT: {
                ((ChatContract.View)this.view).onFetchStateChange(FetchState.LOADING);
                if (this.contentId == null) break;
                this.bindUserChatEventReceiver();
                break;
            }
            case NONE: {
                this.tempItems = new ArrayList<SendItem>();
                ((ChatContract.View)this.view).onFetchStateChange(FetchState.LOADING);
                Plugin plugin = PluginStore.get().pluginState.get();
                if (plugin == null || plugin.getId() == null) break;
                this.bindWelcomeMessage();
            }
        }
    }

    @Override
    protected void handleAction(ActionType actionType) {
        switch (actionType) {
            case SOCKET_DISCONNECTED: 
            case SHUTDOWN: {
                this.init = false;
                this.backwardId = null;
                this.queueItems.clear();
            }
        }
    }

    private void bindWelcomeMessage() {
        this.welcomeBinder = ChatSelector.bindWelcomeMessage((Action3<FetchState, SupportBotEntry, CharSequence>)((Action3)(fetchState, supportBotEntry, welcomeMessage) -> {
            switch (fetchState) {
                case FAILED: {
                    ((ChatContract.View)this.view).onFetchStateChange(FetchState.FAILED);
                    break;
                }
                case COMPLETE: {
                    if (supportBotEntry != null) {
                        this.contentType = ChatContentType.SUPPORT_BOT_CHAT;
                        this.contentId = supportBotEntry.getId();
                        ((ChatAdapterContract.Model)this.adapterModel).setInitMessage(new SupportBotMessageItem((SupportBotEntry)supportBotEntry));
                        ((ChatContract.View)this.view).onWelcomeStateChange(ChatContentType.SUPPORT_BOT_CHAT, false);
                        ((ChatContract.View)this.view).onFetchStateChange(FetchState.COMPLETE);
                    } else if (welcomeMessage != null) {
                        ((ChatAdapterContract.Model)this.adapterModel).setInitMessage(new WelcomeMessageItem((CharSequence)welcomeMessage));
                        this.bindWelcomeAcceptInput();
                        ((ChatContract.View)this.view).onFetchStateChange(FetchState.COMPLETE);
                    } else {
                        ((ChatContract.View)this.view).onFetchStateChange(FetchState.FAILED);
                    }
                    if (this.welcomeBinder == null) break;
                    this.welcomeBinder.unbind();
                }
            }
        }));
    }

    private void bindWelcomeAcceptInput() {
        if (this.welcomeAcceptInputBinder == null) {
            this.welcomeAcceptInputBinder = ChannelSelector.bindAcceptInput((Action1<Boolean>)((Action1)acceptInput -> ((ChatContract.View)this.view).onWelcomeStateChange(ChatContentType.NONE, (boolean)acceptInput)));
        }
    }

    private void createUserChat() {
        if (this.contentType == ChatContentType.NONE && !Api.isRunning(ActionType.CREATE_USER_CHAT)) {
            Plugin plugin = PluginStore.get().pluginState.get();
            String pluginId = plugin != null ? plugin.getId() : null;
            Activity topActivity = GlobalStore.get().topActivity.get();
            String url = (String)Optional.ofNullable((Object)topActivity).map(Object::getClass).map(Class::getSimpleName).orElse((Object)"");
            if (pluginId != null) {
                ChatAction.createUserChat(pluginId, url, new RestSubscriber<UserChatWrapper>(){

                    @Override
                    public void onError(RetrofitException error) {
                        ChatPresenter.this.setTempSendingItemsFail();
                    }

                    @Override
                    public void onSuccess(@NonNull UserChatWrapper repo) {
                        ChatPresenter.this.handleUserChatInit(repo.getUserChat(), repo.getMessage());
                    }
                });
            }
        }
    }

    private void createSupportBotUserChat(final SendActionItem item) {
        if (this.contentType == ChatContentType.SUPPORT_BOT_CHAT && !Api.isRunning(ActionType.CREATE_USER_CHAT)) {
            String supportBotId = this.contentId;
            String url = (String)Optional.ofNullable((Object)GlobalStore.get().topActivity.get()).map(Object::getClass).map(Class::getSimpleName).orElse((Object)"");
            this.addTempSendItem(item);
            SupportBotAction.createSupportBotUserChat(supportBotId, url, new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter.this.removeTempSendingItem(item);
                }

                @Override
                public void onSuccess(@NonNull UserChatWrapper repo) {
                    item.updateMessageOnActionInput(repo.getMessage());
                    ChatPresenter.this.handleUserChatInit(repo.getUserChat(), repo.getMessage());
                }
            });
        }
    }

    private void addTempSendItem(SendItem item) {
        if (item != null) {
            this.addTempSendItems(Collections.singleton(item));
        }
    }

    private void addTempSendItems(Collection<SendItem> items) {
        if (this.tempItems != null && items != null && items.size() > 0) {
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItems(items);
            this.tempItems.addAll(items);
        }
    }

    private boolean removeTempSendingItem(SendItem item) {
        if (this.tempItems != null && item != null) {
            ((ChatAdapterContract.Model)this.adapterModel).removeMessageItem(item);
            return this.tempItems.remove(item);
        }
        return false;
    }

    private void setTempSendingItemsChatId(String chatId) {
        if (this.tempItems != null) {
            for (SendItem item : this.tempItems) {
                item.setChatId(chatId);
            }
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItems(this.tempItems);
        }
    }

    private void setTempSendingItemsFail() {
        if (this.tempItems != null) {
            for (SendItem item : this.tempItems) {
                item.doFail();
            }
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItems(this.tempItems);
        }
    }

    private void handleUserChatInit(UserChat userChat, Message message) {
        if (this.welcomeBinder != null) {
            this.welcomeBinder.unbind();
            this.welcomeBinder = null;
        }
        if (this.welcomeAcceptInputBinder != null) {
            this.welcomeAcceptInputBinder.unbind();
            this.welcomeAcceptInputBinder = null;
        }
        if (userChat != null && userChat.getId() != null) {
            this.contentType = ChatContentType.USER_CHAT;
            this.contentId = userChat.getId();
            ((ChatAdapterContract.Model)this.adapterModel).replaceInitMessageItem(message);
            this.setTempSendingItemsChatId(userChat.getId());
            this.bindUserChatEventReceiver();
        }
    }

    private void bindUserChatEventReceiver() {
        if (this.joinSubscription == null && this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            this.getChatManager().attachListener(this);
            this.bind(SocketSelector.bindSocket((Action1<SocketStatus>)((Action1)socketStatus -> {
                if (socketStatus == SocketStatus.READY) {
                    this.fetchUserChat();
                }
            })));
            this.bind(ChatSelector.bindChat(this.contentId, (Action5<UserChat, Message, Boolean, Boolean, Boolean>)((Action5)(userChat, recentMessage, acceptInput, temporaryInputOpened, isWorking) -> {
                if (temporaryInputOpened.booleanValue() && !"solved".equals(userChat.getState())) {
                    ChatStore.get().temporaryInputOpenedState.set(false);
                }
                ChatAction.read(this.contentId);
                ((ChatContract.View)this.view).onChatStateChange((UserChat)userChat, (Message)recentMessage, (boolean)acceptInput, (boolean)temporaryInputOpened, (boolean)isWorking);
            })));
            this.bind(ProfileBotSelector.bindProfileBotActivation((Action1<Boolean>)((Action1)isActivated -> {
                if (isActivated.booleanValue()) {
                    ((ChatContract.View)this.view).setInputDim(true);
                }
            })));
            this.bind(ChatSelector.bindTyping((Action1<Boolean>)((Action1)isTyping -> SocketManager.typing(Typing.create(isTyping != false ? "start" : "stop", this.contentId)))));
            this.bind(ChatSelector.bindHostTyping(this.contentId, (Action1<List<Typing>>)((Action1)typings -> ((ChatAdapterContract.Model)this.adapterModel).setTypings((List<Typing>)typings))));
            this.joinSubscription = SocketManager.observable().subscribe(joinedChatId -> {
                if (this.contentId != null && this.contentId.equals(joinedChatId)) {
                    this.fetchInitMessages();
                }
            });
            this.messageSubscription = RxBus.subscribe((Action1<Object>)((Action1)o -> {
                if (o instanceof Message) {
                    Message message = (Message)o;
                    if (this.contentId != null && CompareUtils.isSame(message.getChatId(), this.contentId)) {
                        this.onReceiveMessage(message);
                    }
                }
            }));
        }
    }

    private void fetchUserChat() {
        ChatAction.fetchUserChat(this.contentId, new RestSubscriber<UserChatWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ((ChatContract.View)ChatPresenter.this.view).onFetchStateChange(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull UserChatWrapper repo) {
                ChatPresenter.this.lastReadSession = repo.getSession();
                ChatPresenter.this.queueItems.clear();
                SocketManager.joinChat(repo.getUserChat().getId());
            }
        });
    }

    private void fetchInitMessages() {
        ChatAction.fetchMessages(this.contentId, new RestSubscriber<MessagesWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                SocketManager.leaveChat(ChatPresenter.this.contentId);
                ((ChatContract.View)ChatPresenter.this.view).onFetchStateChange(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull MessagesWrapper repo) {
                ArrayList<Message> messages = new ArrayList<Message>(repo.getMessages());
                ChatPresenter.this.init = true;
                ChatPresenter.this.backwardId = repo.getNext();
                if (ChatPresenter.this.tempItems != null && ChatPresenter.this.tempItems.size() > 0) {
                    ChatPresenter.this.getChatManager().sendMessages(ChatPresenter.this.tempItems);
                    ChatPresenter.this.tempItems.clear();
                    ChatPresenter.this.tempItems = null;
                }
                if (ChatPresenter.this.queueItems.size() > 0) {
                    messages.addAll(ChatPresenter.this.queueItems);
                    ChatPresenter.this.queueItems.clear();
                }
                ((ChatAdapterContract.Model)ChatPresenter.this.adapterModel).setMessages(messages, ChatPresenter.this.getChatManager().getUnsentItems(), ChatPresenter.this.lastReadSession, repo.getNext());
                ((ChatContract.View)ChatPresenter.this.view).scrollToBottom();
                ((ChatContract.View)ChatPresenter.this.view).onFetchStateChange(FetchState.COMPLETE);
                ChatAction.read(ChatPresenter.this.contentId);
            }
        });
    }

    @Override
    public void fetchBackwardMessages() {
        if (!Api.isRunning(ActionType.FETCH_BACKWARD_MESSAGES) && this.backwardId != null) {
            ChatAction.fetchBackwardMessages(this.contentId, this.backwardId, new RestSubscriber<MessagesWrapper>(){

                @Override
                public void onSuccess(@NonNull MessagesWrapper repo) {
                    ((ChatAdapterContract.Model)ChatPresenter.this.adapterModel).addMessages(repo.getMessages(), ChatPresenter.this.lastReadSession, repo.getNext());
                    ChatPresenter.this.backwardId = repo.getNext();
                }
            });
        }
    }

    @Override
    public void sendText(String message) {
        if (this.tempItems != null) {
            this.addTempSendItem(new SendTextItem(null, message));
            this.createUserChat();
        } else if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            this.getChatManager().sendMessage(new SendTextItem(this.contentId, message));
        }
        ((ChatContract.View)this.view).scrollToBottom();
    }

    @Override
    public void uploadFiles(List<PhotoItem> photoItems) {
        if (photoItems != null) {
            List items = Stream.of(photoItems).mapIndexed((index, item) -> new SendFileItem(this.contentId, index, item.getUri(), item.getName(), item.getSize())).toList();
            if (this.tempItems != null) {
                this.addTempSendItems(items);
                this.createUserChat();
            } else if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
                this.getChatManager().sendMessages(items);
            }
            ((ChatContract.View)this.view).scrollToBottom();
        }
    }

    @Override
    public void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        if (this.contentType == ChatContentType.SUPPORT_BOT_CHAT && "supportBot".equals(actionType)) {
            this.createSupportBotUserChat(new SendActionItem(null, actionType, actionButton));
            return;
        }
        if (CompareUtils.exists((Comparable)((Object)actionType), (Comparable[])new String[]{"userChat.solve", "userChat.close"}) && CompareUtils.isSame(actionButton.getKey(), "reopen")) {
            this.reopenChat(actionButton);
            return;
        }
        if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            this.getChatManager().sendMessage(new SendActionItem(this.contentId, actionType, actionButton));
        }
        ((ChatContract.View)this.view).scrollToBottom();
    }

    @Override
    public void onCreateSupportBotClick() {
        SupportBotAction.createMarketingSupportBotUserChat(this.contentId);
    }

    @Override
    public void resend(SendItem item) {
        if (this.tempItems != null && this.removeTempSendingItem(item)) {
            item.renew();
            this.tempItems.add(item);
            this.createUserChat();
        } else if (this.contentType == ChatContentType.USER_CHAT) {
            this.getChatManager().resend(item);
        }
        ((ChatContract.View)this.view).scrollToBottom();
    }

    @Override
    public void removeFailedItem(SendItem item) {
        if (this.tempItems == null || !this.removeTempSendingItem(item)) {
            this.getChatManager().remove(item);
        }
    }

    @Override
    public void cancelSendingFile(SendFileItem item) {
        this.getChatManager().cancelRecentSendingFile();
    }

    @Override
    public void requestCountries(final ProfileBotMessageItem item) {
        if (ProfileBotStore.get().requestState.get() != FetchState.LOADING) {
            List<Country> countries = CountryStore.get().countries.get();
            if (countries != null) {
                ((ChatContract.View)this.view).showCountryDialog(countries, item);
            } else if (!Api.isRunning(ActionType.FETCH_COUNTRIES)) {
                CountryAction.fetchCountries(new RestSubscriber<List<Country>>(){

                    @Override
                    public void onSuccess(@NonNull List<Country> countries) {
                        CountryStore.get().countries.set(countries);
                        if (countries.size() > 0) {
                            ((ChatContract.View)ChatPresenter.this.view).showCountryDialog(countries, item);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void selectCountry(String countryCode, ProfileBotMessageItem item) {
        Object inputValue;
        if (ProfileBotStore.get().requestState.get() != FetchState.LOADING && "mobileNumber".equals(ProfileBotStore.get().inputKey.get()) && (inputValue = ProfileBotStore.get().inputValue.get()) instanceof MobileNumber) {
            ((MobileNumber)inputValue).setCountryCode(Integer.valueOf(countryCode));
            ProfileBotStore.get().inputValue.set(inputValue);
            ProfileBotStore.get().requestState.set(FetchState.COMPLETE);
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
        }
    }

    @Override
    public void updateProfile(ProfileBotMessageItem item) {
        ProfileBotStore.get().requestState.set(FetchState.LOADING);
        ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
        UserAction.updateProfileBot(item.getUserChatId(), item.getMessageId(), (Action1<MessageWrapper>)((Action1)repo -> {
            ProfileBotStore.get().requestFocus.set(true);
            ProfileBotStore.get().requestState.set(FetchState.COMPLETE);
            ProfileBotStore.get().inputKey.set(null);
            ProfileBotStore.get().inputValue.set(null);
            if (this.init) {
                ((ChatAdapterContract.Model)this.adapterModel).addMessage(repo.getMessage());
            }
        }), () -> {
            ProfileBotStore.get().requestFocus.set(true);
            ProfileBotStore.get().requestState.set(FetchState.FAILED);
            ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
        });
    }

    private void reopenChat(@NonNull ActionButton actionButton) {
        Message message = actionButton.getMessage();
        message.clearAction();
        ((ChatAdapterContract.Model)this.adapterModel).addMessage(message);
        ChatStore.get().temporaryInputOpenedState.set(true);
        ((ChatContract.View)this.view).scrollToBottom();
    }

    @Override
    public void release() {
        super.release();
        this.getChatManager().clearListener();
        if (this.welcomeBinder != null) {
            this.welcomeBinder.unbind();
            this.welcomeBinder = null;
        }
        if (this.welcomeAcceptInputBinder != null) {
            this.welcomeAcceptInputBinder.unbind();
            this.welcomeAcceptInputBinder = null;
        }
        if (this.joinSubscription != null && !this.joinSubscription.isUnsubscribed()) {
            this.joinSubscription.unsubscribe();
            this.joinSubscription = null;
        }
        if (this.messageSubscription != null && !this.messageSubscription.isUnsubscribed()) {
            this.messageSubscription.unsubscribe();
            this.messageSubscription = null;
        }
        if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            SocketManager.leaveChat(this.contentId);
        }
        TypingStore.get().myTypingState.upsert(Typing.dummy());
        if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            SocketManager.typing(Typing.create("stop", this.contentId));
        }
    }

    @Override
    public void onMessageItemUpsert(MessageItem item) {
        ((ChatAdapterContract.Model)this.adapterModel).addMessageItem(item);
    }

    @Override
    public void onMessageItemRemove(MessageItem item) {
        ((ChatAdapterContract.Model)this.adapterModel).removeMessageItem(item);
    }

    @Override
    public void onMessageSendSuccess(Message message) {
        this.onReceiveMessage(message);
    }

    private void onReceiveMessage(Message message) {
        if (this.init) {
            ProfileEntity profileEntity;
            boolean isScrollOnBottom = ((ChatContract.View)this.view).isScrollOnBottom();
            ((ChatAdapterContract.Model)this.adapterModel).addMessage(message);
            if (isScrollOnBottom) {
                ((ChatContract.View)this.view).scrollToBottom();
            } else if (!CompareUtils.isSame(message.getPersonType(), "user") && (profileEntity = ProfileSelector.getProfile(message.getPersonType(), message.getPersonId())) != null) {
                ((ChatContract.View)this.view).showNewMessageAlert(profileEntity);
            }
        } else if (Api.isRunning(ActionType.FETCH_MESSAGES)) {
            this.queueItems.add(message);
        }
    }
}

