package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.open.callback.UserUpdateCallback;
import com.zoyi.channel.plugin.android.open.exception.ChannelException;
import com.zoyi.channel.plugin.android.open.model.UserData;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Action1;

import java.util.*;

public class UserAction {

  public static void touch() {
    Plugin plugin = PluginStore.get().pluginState.get();
    String sessionJWT = GlobalStore.get().jwt.get();

    if (plugin != null && sessionJWT != null) {
      Api.touch(plugin.getId(), sessionJWT)
          .runBy(ActionType.TOUCH)
          .cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.SHUTDOWN)
          .run();
    }
  }

  public static void updateProfileBot(
      @Nullable String userChatId,
      @Nullable String messageId,
      Action1<MessageWrapper> onSuccess,
      Action0 onFail
  ) {
    String key = ProfileBotStore.get().inputKey.get();
    Object value = ProfileBotStore.get().inputValue.get();

    RestSubscriber<MessageWrapper> subscriber = new RestSubscriber<MessageWrapper>() {
      @Override
      public void onError(RetrofitException error) {
        if (onFail != null) {
          onFail.call();
        }
      }

      @Override
      public void onSuccess(@NonNull MessageWrapper repo) {
        if (onSuccess != null) {
          onSuccess.call(repo);
        }

        if (repo.getMessage() != null && repo.getMessage().getProfileBot() != null) {
          for (ProfileBot profileBot : repo.getMessage().getProfileBot()) {
            if (CompareUtils.isSame(profileBot.getKey(), key)) {
              handleUserProfileUpdate(key, profileBot.getValue());
            }
          }
        }
      }
    };

    if (userChatId != null && messageId != null && key != null && value != null) {
      if (value instanceof MobileNumber) {
        MobileNumber mobileNumber = (MobileNumber) value;

        Api.updateProfileBot(
            userChatId,
            messageId,
            RequestUtils.form().set(
                key,
                String.format(Locale.US, "+%d%s", mobileNumber.getCountryCode(), mobileNumber.getPhoneNumber())
            ).create())
            .runBy(ActionType.UPDATE_USER_PROFILE_BOT)
            .cancelBy(ActionType.SHUTDOWN)
            .run(subscriber);
      } else {
        Api.updateProfileBot(userChatId, messageId, RequestUtils.form().set(key, value).create())
            .runBy(ActionType.UPDATE_USER_PROFILE_BOT)
            .cancelBy(ActionType.SHUTDOWN)
            .run(subscriber);
      }
    }
  }

  public static void updateUserProfile(
      @Nullable String key,
      @Nullable String value,
      boolean isNumeric,
      Action0 onSuccess,
      Action1<String> onFail
  ) {
    if (key != null) {
      HashMap<String, Object> profileMap = new HashMap<>();

      try {
        if (value == null || !isNumeric) {
          profileMap.put(key, value);
        } else {
          profileMap.put(key, Double.valueOf(value));
        }
      } catch (Exception ex) {
        profileMap.put(key, value);
      }

      updateUser(profileMap, user -> {
        onSuccess.call();

        if (user != null) {
          handleUserProfileUpdate(key, user.getProfileValue(key));
        }
      }, onFail);
    } else {
      onFail.call(null);
    }
  }

  public static void updateLanguage(String lang, @Nullable Action1<User> onSuccess, @Nullable Action1<String> onFail) {
    RequestBody requestBody = RequestUtils.form()
        .set("language", lang)
        .create();

    Api.updateUser(requestBody)
        .cancelBy(ActionType.SHUTDOWN)
        .run(new RestSubscriber<UserWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            if (onFail != null) {
              onFail.call(error.getMessage());
            }
          }

          @Override
          public void onSuccess(@NonNull UserWrapper repo) {
            if (onSuccess != null) {
              onSuccess.call(repo.getUser());
            }
          }
        });
  }

  public static void updateUser(Map<String, Object> profileMap, @Nullable Action1<User> onSuccess, @Nullable Action1<String> onFail) {
    RequestBody requestBody = RequestUtils.form()
        .set("profile", profileMap)
        .create();

    Api.updateUser(requestBody)
        .cancelBy(ActionType.SHUTDOWN)
        .run(new RestSubscriber<UserWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            if (onFail != null) {
              onFail.call(error.getMessage());
            }
          }

          @Override
          public void onSuccess(@NonNull UserWrapper repo) {
            if (onSuccess != null) {
              onSuccess.call(repo.getUser());
            }
          }
        });
  }

  public static void updateSubscription(boolean unsubscribed) {
    RequestBody requestBody = RequestUtils.form()
        .set("unsubscribed", unsubscribed)
        .create();

    Api.updateUser(requestBody)
        .cancelBy(ActionType.SHUTDOWN)
        .run(new RestSubscriber<UserWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            // refresh by current data to raise binder
            UserStore.get().user.set(UserStore.get().user.get());
          }
        });
  }

  public static void updateUser(@Nullable UserData userData, @Nullable UserUpdateCallback callback) {
    if (userData == null || userData.getRequestBody() == null) {
      if (callback != null) {
        callback.callback(ChannelException.newInstance("Request payload cannot be empty"), null);
      }
      return;
    }

    Api.updateUser(userData.getRequestBody())
        .cancelBy(ActionType.SHUTDOWN)
        .run(new RestSubscriber<UserWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            if (callback != null) {
              callback.callback(ChannelException.newInstance(error.getMessage()), null);
            }
          }

          @Override
          public void onSuccess(@NonNull UserWrapper repo) {
            if (callback != null) {
              callback.callback(null, com.zoyi.channel.plugin.android.User.newInstance(repo.getUser()));
            }
          }
        });
  }

  public static void closePopUp() {
    Api.closePopUp().run(new RestSubscriber<>());
  }

  private static void handleUserProfileUpdate(@Nullable String key, @Nullable Object value) {
    ChannelPluginListener listener = ChannelIO.getChannelPluginListener();

    if (key != null && listener != null) {
      listener.onChangeProfile(key, value);
    }
  }
}
