package com.zoyi.channel.plugin.android.view.youtube.player.util;


import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.AbstractYouTubePlayerListener;

/**
 * Utility class responsible for tracking the state of YouTubePlayer. This is a YouTubePlayerListener, therefore to work it has to be added
 * as listener to a YouTubePlayer.
 */
public class YouTubePlayerTracker extends AbstractYouTubePlayerListener {

  /**
   * @return the player state. A value from [PlayerConstants.PlayerState]
   */
  private PlayerConstants.PlayerState state = PlayerConstants.PlayerState.UNKNOWN;
  private float currentSecond = 0f;
  private float videoDuration = 0f;

  @Nullable
  private String videoId = null;

  @Override
  public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
    this.state = state;
  }

  @Override
  public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
    currentSecond = second;
  }

  @Override
  public void onVideoDuration(YouTubePlayer youTubePlayer, float duration) {
    videoDuration = duration;
  }

  @Override
  public void onVideoId(YouTubePlayer youTubePlayer, String videoId) {
    this.videoId = videoId;
  }
}