package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;
import com.zoyi.channel.plugin.android.view.video_player.BubblePopUpVideoPlayerView;
import com.zoyi.channel.plugin.android.view.video_player.BubblePopUpYouTubeVideoPlayerView;

public class BubblePopUpMediaThumbnailView extends AbsPopUpMediaThumbnailView {

  public BubblePopUpMediaThumbnailView(@NonNull Context context) {
    super(context);
  }

  public BubblePopUpMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public BubblePopUpMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Nullable
  @Override
  protected AbsVideoPlayerView createVideoPlayerView(Context context, String messageId, File attachment, OnClickListener listener) {
    if (attachment != null) {
      BubblePopUpVideoPlayerView bubblePopUpVideoPlayerView = new BubblePopUpVideoPlayerView(context).setUrl(messageId, attachment);
      bubblePopUpVideoPlayerView.setOnClickListener(listener);
      return bubblePopUpVideoPlayerView;
    }

    return null;
  }

  @Override
  protected AbsVideoPlayerView createYoutubePlayerView(
      Context context,
      String messageId,
      String webPageId,
      String videoId,
      OnClickListener listener
  ) {
    BubblePopUpYouTubeVideoPlayerView bubblePopUpYouTubeVideoPlayerView = new BubblePopUpYouTubeVideoPlayerView(context);
    bubblePopUpYouTubeVideoPlayerView.setVideoId(messageId, webPageId, videoId, listener);
    bubblePopUpYouTubeVideoPlayerView.setOnClickListener(listener);
    return bubblePopUpYouTubeVideoPlayerView;
  }

  @Override
  protected Point getImageSize(float width, float height) {
    float ratio = width / height;
    int viewHeight = ResUtils.getDimen(getContext(), R.dimen.ch_popup_bubble_attachment_min_width);

    return new Point((int) (viewHeight * ratio), viewHeight);
  }
}
