package com.zoyi.channel.plugin.android.enumerate;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.ResUtils;

public enum DayOfWeekType {

  MON(0, Const.DAY_OF_WEEK_MON, "ch.out_of_work.mon"),
  TUE(1, Const.DAY_OF_WEEK_TUE, "ch.out_of_work.tue"),
  WED(2, Const.DAY_OF_WEEK_WED, "ch.out_of_work.wed"),
  THU(3, Const.DAY_OF_WEEK_THU, "ch.out_of_work.thu"),
  FRI(4, Const.DAY_OF_WEEK_FRI, "ch.out_of_work.fri"),
  SAT(5, Const.DAY_OF_WEEK_SAT, "ch.out_of_work.sat"),
  SUN(6, Const.DAY_OF_WEEK_SUN, "ch.out_of_work.sun"),
  UNKNOWN(7, "", "ch.unknown");

  private int index;
  private String value;
  private String translationKey;

  DayOfWeekType(int index, String value, String translationKey) {
    this.index = index;
    this.value = value;
    this.translationKey = translationKey;
  }

  public int getIndex() {
    return this.index;
  }

  public String getValue() {
    return this.value;
  }

  public static DayOfWeekType fromString(String dayOfWeek) {
    switch (dayOfWeek) {
      case Const.DAY_OF_WEEK_MON:
        return MON;
      case Const.DAY_OF_WEEK_TUE:
        return TUE;
      case Const.DAY_OF_WEEK_WED:
        return WED;
      case Const.DAY_OF_WEEK_THU:
        return THU;
      case Const.DAY_OF_WEEK_FRI:
        return FRI;
      case Const.DAY_OF_WEEK_SAT:
        return SAT;
      case Const.DAY_OF_WEEK_SUN:
        return SUN;
      default:
        return UNKNOWN;
    }
  }

  public String getString() {
    return ResUtils.getString(this.translationKey);
  }
}
