package com.zoyi.channel.plugin.android.action;

import android.app.Activity;

import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;

import java.util.HashMap;
import java.util.Map;

public class EventAction {

  public static void trackPageView() {
    Map<String, Object> property = new HashMap<>();
    Activity activity = GlobalStore.get().topActivity.get();

    if (activity != null && !ChannelUtils.isChannelPluginActivity(activity)) {
      property.put(Const.PROPERTY_URL, activity.getClass().getSimpleName());
    }

    track(new Event(Const.PAGE_VIEW_EVENT_NAME, property));
  }

  public static void track(Event event) {
    Plugin plugin = PluginStore.get().pluginState.get();
    String sessionJWT = GlobalStore.get().jwt.get();

    if (plugin != null && plugin.getId() != null && sessionJWT != null) {
      Api.trackEvent(plugin.getId(), event.getName(), event.getPropertyToJson(), sessionJWT)
          .cancelBy(ActionType.SHUTDOWN)
          .run();
    }
  }
}
