package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.selector.SocketSelector;
import com.zoyi.channel.plugin.android.selector.UserSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;

public class ChannelActionHandler {

  @Nullable
  private ChannelPluginListener listener;

  @Nullable
  private Binder socketBinder;

  @Nullable
  private Binder countHandler;

  @Nullable
  private Binder inAppPushHandler;

  @Nullable
  private Binder messengerVisibilityBinder;

  public void handle() {
    messengerVisibilityBinder = GlobalSelector.bindMessengerVisibility(visible -> {
      if (listener != null) {
        if (visible) {
          listener.willShowMessenger();
        } else {
          listener.willHideMessenger();
        }
      }
    });

    socketBinder = SocketSelector.bindSocket(socketStatus -> {
      if (socketStatus == SocketStatus.READY) {
        UserAction.touch();
      }
    });

    countHandler = UserSelector.bindUserAlertCount(count -> {
      if (listener != null && count != null) {
        listener.onChangeBadge(count);
      }
    });

    inAppPushHandler = GlobalSelector.bindInAppPush(pushEvent -> {
      if (listener != null && pushEvent != null) {
        listener.onReceivePush(pushEvent);
      }
    });
  }

  public void unHandle() {
    if (messengerVisibilityBinder != null) {
      messengerVisibilityBinder.unbind();
      messengerVisibilityBinder = null;
    }

    if (socketBinder != null) {
      socketBinder.unbind();
      socketBinder = null;
    }

    if (countHandler != null) {
      countHandler.unbind();
      countHandler = null;
    }

    if (inAppPushHandler != null) {
      inAppPushHandler.unbind();
      inAppPushHandler = null;
    }
  }

  @Nullable
  public ChannelPluginListener getListener() {
    return listener;
  }

  public void setListener(@Nullable ChannelPluginListener listener) {
    this.listener = listener;
  }

  public void clearListener() {
    this.listener = null;
  }
}
