/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.selector.SocketSelector;
import com.zoyi.channel.plugin.android.selector.UserSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.rx.functions.Action1;

public class ChannelActionHandler {
    @Nullable
    private ChannelPluginListener listener;
    @Nullable
    private Binder socketBinder;
    @Nullable
    private Binder countHandler;
    @Nullable
    private Binder inAppPushHandler;
    @Nullable
    private Binder messengerVisibilityBinder;

    public void handle() {
        this.messengerVisibilityBinder = GlobalSelector.bindMessengerVisibility((Action1<Boolean>)((Action1)visible -> {
            if (this.listener != null) {
                if (visible.booleanValue()) {
                    this.listener.willShowMessenger();
                } else {
                    this.listener.willHideMessenger();
                }
            }
        }));
        this.socketBinder = SocketSelector.bindSocket((Action1<SocketStatus>)((Action1)socketStatus -> {
            if (socketStatus == SocketStatus.READY) {
                UserAction.touch();
            }
        }));
        this.countHandler = UserSelector.bindUserAlertCount((Action1<Integer>)((Action1)count -> {
            if (this.listener != null && count != null) {
                this.listener.onChangeBadge((int)count);
            }
        }));
        this.inAppPushHandler = GlobalSelector.bindInAppPush((Action1<PushEvent>)((Action1)pushEvent -> {
            if (this.listener != null && pushEvent != null) {
                this.listener.onReceivePush((PushEvent)pushEvent);
            }
        }));
    }

    public void unHandle() {
        if (this.messengerVisibilityBinder != null) {
            this.messengerVisibilityBinder.unbind();
            this.messengerVisibilityBinder = null;
        }
        if (this.socketBinder != null) {
            this.socketBinder.unbind();
            this.socketBinder = null;
        }
        if (this.countHandler != null) {
            this.countHandler.unbind();
            this.countHandler = null;
        }
        if (this.inAppPushHandler != null) {
            this.inAppPushHandler.unbind();
            this.inAppPushHandler = null;
        }
    }

    @Nullable
    public ChannelPluginListener getListener() {
        return this.listener;
    }

    public void setListener(@Nullable ChannelPluginListener listener) {
        this.listener = listener;
    }

    public void clearListener() {
        this.listener = null;
    }
}

