package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.view.listener.OnPushClickListener;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.store.InAppPushStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.AlarmCenter;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.message.TextMessageView;
import com.zoyi.channel.plugin.android.view.media_thumbnail.AbsPopUpMediaThumbnailView;
import com.zoyi.channel.plugin.android.view.textview.FileRowTextView;
import com.zoyi.com.annimon.stream.Stream;

/**
 * Created by jerry on 2018. 11. 20..
 */

public abstract class BasePushView extends LinearLayout {

  protected Context context;

  protected View root;

  protected View itemRoot;

  protected View buttonPopupClose;

  protected AvatarLayout avatarPopup;

  protected TextView textPopupName;

  protected TextMessageView viewPopupMessage;

  protected AbsPopUpMediaThumbnailView viewPopUpMedia;
  private View imagePopUpImageMultiple;

  protected FileRowTextView viewFileRow;

  @Nullable
  protected OnPushClickListener onPushClickListener;

  @Nullable
  protected Binder binder;

  @Nullable
  protected Message item;

  public BasePushView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public BasePushView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public BasePushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  protected abstract int getLayoutId();

  @Initializer
  protected void init(Context context) {
    this.context = context;

    root = LayoutInflater.from(context).inflate(getLayoutId(), this, true);
    root.setVisibility(GONE);

    itemRoot = root.findViewById(R.id.ch_rootPopUp);
    itemRoot.setOnClickListener(v -> onClickPush());

    avatarPopup = root.findViewById(R.id.ch_avatarPopUp);
    textPopupName = root.findViewById(R.id.ch_textPopUpName);

    viewPopupMessage = root.findViewById(R.id.ch_viewPopUpMessage);

    viewFileRow = root.findViewById(R.id.ch_textPopUpFileName);

    viewPopUpMedia = root.findViewById(R.id.ch_viewPopUpMedia);
    viewPopUpMedia.setOnPushClickListener(v -> onClickPush());

    imagePopUpImageMultiple = root.findViewById(R.id.ch_imagePopUpImageMultiple);

    buttonPopupClose = root.findViewById(R.id.ch_buttonPopUpClose);
    buttonPopupClose.setOnClickListener(v -> {
      InAppPushStore.get().inAppPushMessage.set(null);
      UserAction.closePopUp();
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
    }
  }

  protected void bindProfileData(String personType, String personId) {
    ProfileEntity person = ProfileSelector.getProfile(personType, personId);

    avatarPopup.setVisibility(View.VISIBLE);
    avatarPopup.set(person);

    textPopupName.setText(person != null ? person.getName() : ResUtils.getUnknown());
  }

  public void setPushClickListener(OnPushClickListener onPushClickListener) {
    this.onPushClickListener = onPushClickListener;
  }

  public void show(Message message) {
    // Reset popup content visibility (button, image.. etc)
    resetView();

    this.item = message;

    // Set avatar, bot name, time
    bindProfileData(message.getPersonType(), message.getPersonId());

    // Set message
    bindContent(message);

    // Set alarm
    if (PrefSupervisor.isEnabledPushAlarm(context)) {
      AlarmCenter.alarm(context);
    }

    root.setVisibility(VISIBLE);
  }

  protected void bindContent(Message message) {
    viewFileRow.setVisibility(View.GONE);
    viewPopupMessage.setVisibility(View.GONE);
    viewPopUpMedia.setVisibility(View.GONE);
    imagePopUpImageMultiple.setVisibility(View.GONE);

    if (message.getBlocks() != null && !message.getBlocks().isEmpty()) {
      viewPopupMessage.setVisibility(View.VISIBLE);
      viewPopupMessage.setMaxLines(
          message.containsPreviewableFile() || message.getWebPage() != null
              ? getAttachmentTextMaxLine()
              : getDefaultTextMaxLine()
      );
      viewPopupMessage.setBlocks(message.getBlocks());
    }

    if (message.getWebPage() != null) {
      bindWebPage(message.getId(), message.getWebPage());
    }

    File file = message.getPrimaryFile();

    if (file != null) {
      if (file.isPreviewable() && message.getWebPage() == null) {
        bindMedia(message, file);
      }

      if (!file.isPreviewable() || !message.hasBlocks()) {
        viewFileRow.setVisibility(View.VISIBLE);
        viewFileRow.setFile(file, message.getFiles().size());
      }
    }
  }

  private void bindMedia(Message message, File file) {
    setMediaSize(file);

    if (Stream.ofNullable(message.getFiles()).filter(File::isPreviewable).toList().size() > 1) {
      imagePopUpImageMultiple.setVisibility(View.VISIBLE);
    }

    viewPopUpMedia.setVisibility(View.VISIBLE);
    viewPopUpMedia.setAttachment(message.getId(), file);
  }

  private void bindWebPage(String messageId, WebPage webPage) {
    if (webPage.getPreviewUrl() != null) {
      setMediaSize(webPage);

      viewPopUpMedia.setVisibility(View.VISIBLE);
      viewPopUpMedia.setWebPage(messageId, webPage);
    }
  }

  protected abstract void setMediaSize(Previewable previewable);

  private void hide() {
    resetView();
  }

  public void resetView() {
    this.item = null;

    root.setVisibility(GONE);

    viewPopUpMedia.clear();

    if (viewPopupMessage != null) {
      viewPopupMessage.setText("");
    }
  }

  private void onClickPush() {
    if (item != null && onPushClickListener != null) {
      onPushClickListener.onPushClick(item.getChatId());
    }
    hide();
  }

  abstract protected int getDefaultTextMaxLine();

  abstract protected int getAttachmentTextMaxLine();

}
