package com.zoyi.channel.plugin.android.selector;

import com.zoyi.channel.plugin.android.model.rest.AppMessenger;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.store.AppMessengerStore;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.store.binder.Binder3;
import com.zoyi.channel.plugin.android.store.state.CollectionState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.rx.functions.Action3;

import java.util.Collection;

public class AppMessengerSelector {

  public static Binder bindIntegrations(Action3<Channel, Plugin, Collection<AppMessenger>> action3) {
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Plugin> pluginState = PluginStore.get().pluginState;
    CollectionState<AppMessenger> appMessengerState = AppMessengerStore.get().appMessengers;

    return new Binder3<>(channelState, pluginState, appMessengerState).bind(action3);
  }
}
