/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import android.content.ContentResolver;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.okhttp3.MediaType;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.okio.BufferedSink;
import com.zoyi.okio.Okio;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamRequestBody
extends RequestBody {
    private final MediaType contentType;
    private final ContentResolver contentResolver;
    private final Uri uri;

    public InputStreamRequestBody(MediaType contentType, ContentResolver contentResolver, Uri uri) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        this.contentType = contentType;
        this.contentResolver = contentResolver;
        this.uri = uri;
    }

    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() throws IOException {
        return -1L;
    }

    public void writeTo(@NonNull BufferedSink sink) throws IOException {
        sink.writeAll(Okio.source((InputStream)this.contentResolver.openInputStream(this.uri)));
    }
}

