package com.zoyi.channel.plugin.android.util;

import com.zoyi.channel.plugin.android.*;
import com.zoyi.channel.plugin.android.global.*;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.Observable;

import java.util.Locale;

/**
 * Created by jerry on 2018. 10. 17..
 */

public class BootManager {

  public static Observable<PluginWrapper> bootPlugin(ChannelPluginSettings pluginSettings, Profile profile) {
    String veilId = PrefSupervisor.getVeilId(ChannelIO.getAppContext());
    if (veilId != null && veilId.length() > 16) {
      veilId = veilId.substring(0, 16);
    }

    if (profile == null) {
      profile = Profile.create();
    }

    return Api.getSimpleApi().boot(
        pluginSettings.getLocale().toString(),
        pluginSettings.getPluginKey(),
        pluginSettings.getMemberId(),
        pluginSettings.getMemberHash(),
        null,
        profile.toJson(),
        veilId
    );
  }

  public static boolean isValidVersion(PackageWrapper packageWrapper, OnBootListener onBootListener) {

    if (packageWrapper == null) {
      if (onBootListener != null) {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
      }
      return false;
    }

    if (packageWrapper.isNeedToUpgrade()) {
      if (onBootListener != null) {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.NOT_AVAILABLE_VERSION, null);
      }
      return false;
    }

    if (!CompareUtils.isSame(packageWrapper.getVersionString(), BuildConfig.CHANNEL_IO_VERSION)) {
      L.i("Newest version is: " + packageWrapper.getVersionString());
    }

    return true;
  }

  public static boolean isValidPlugin(PluginWrapper pluginWrapper, OnBootListener onBootListener) {
    if (pluginWrapper == null || !pluginWrapper.isValid()) {
      if (onBootListener != null) {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
      }
      return false;
    }

    if (!pluginWrapper.canUseMobileSDK()) {
      if (onBootListener != null) {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.REQUIRE_PAYMENT, null);
      }
      return false;
    }

    return true;
  }

  public static void sendNetworkError(OnBootListener onBootListener, RetrofitException exception) {
    if (onBootListener != null) {
      String errorMessage = Const.ERROR_UNKNOWN;
      if (exception != null) {
        ChannelPluginCompletionStatus status;
        errorMessage = exception.getMessage();

        if (exception.is4xxClientError()) {
          status = ChannelPluginCompletionStatus.ACCESS_DENIED;
        } else if (exception.is5xxServerError()) {
          status = ChannelPluginCompletionStatus.SERVICE_UNDER_CONSTRUCTION;
        } else if (exception.isConnectionTimeOutError()) {
          status = ChannelPluginCompletionStatus.NETWORK_TIMEOUT;
        } else if (exception.isHttpError()) {
          status = ChannelPluginCompletionStatus.NOT_INITIALIZED;
        } else {
          status = ChannelPluginCompletionStatus.UNKNOWN_ERROR;
        }

        onBootListener.onCompletion(status, null);
      } else {
        onBootListener.onCompletion(ChannelPluginCompletionStatus.UNKNOWN_ERROR, null);
      }

      L.e(errorMessage);
    }
  }
}
