/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderInteractionListener;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.BootDataSelector;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.ComponentUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.button.MaskImageButton;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;
import com.zoyi.rx.functions.Action3;

public class LoungeHeaderView
extends LinearLayout {
    private TextView textChannel;
    private CHTextView textResponse;
    private ImageView imageResponse;
    private CHTextView textResponseDescription;
    private View layoutWorkingTime;
    private CHTextView textWorkingTime;
    private MaskImageButton imageWorkingTime;
    private MaskImageButton settingsButton;
    private MaskImageButton closeButton;
    @ColorInt
    private int darkTextColor;
    @Nullable
    private Binder binder;
    @Nullable
    private LoungeHeaderInteractionListener loungeHeaderInteractionListener;

    public LoungeHeaderView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public LoungeHeaderView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoungeHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(@NonNull Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_lounge_header, (ViewGroup)this, true);
        this.textChannel = (TextView)view.findViewById(R.id.textCompanyLoungeHeader);
        this.textResponse = (CHTextView)view.findViewById(R.id.textResponseDelayLoungeHeader);
        this.imageResponse = (ImageView)view.findViewById(R.id.imageResponseDelayLoungeHeader);
        this.textResponseDescription = (CHTextView)view.findViewById(R.id.textResponseDelayDescriptionLoungeHeader);
        this.layoutWorkingTime = this.findViewById(R.id.layoutWorkingTimeLoungeHeader);
        this.textWorkingTime = (CHTextView)this.findViewById(R.id.textWorkingTimeLoungeHeader);
        this.imageWorkingTime = (MaskImageButton)this.findViewById(R.id.iconWorkingTimeLoungeHeader);
        this.darkTextColor = ContextCompat.getColor((Context)context, (int)R.color.ch_charcoal_grey);
        this.settingsButton = (MaskImageButton)view.findViewById(R.id.buttonSettings);
        this.closeButton = (MaskImageButton)view.findViewById(R.id.buttonClose);
        this.layoutWorkingTime.setOnClickListener(v -> {
            String workingTimeText;
            Channel channel = ChannelStore.get().channelState.get();
            String string2 = workingTimeText = channel != null ? channel.getWorkingTimeText() : null;
            if (!TextUtils.isEmpty((CharSequence)workingTimeText)) {
                new ChannelDialog(context).setDescription(workingTimeText).show();
            }
        });
        this.settingsButton.setOnClickListener(v -> {
            if (this.loungeHeaderInteractionListener != null) {
                this.loungeHeaderInteractionListener.onSettingsClick();
            }
        });
        this.closeButton.setOnClickListener(v -> {
            if (this.loungeHeaderInteractionListener != null) {
                this.loungeHeaderInteractionListener.onExitClick();
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.binder = BootDataSelector.bindBootData((Action3<Plugin, Channel, Integer>)((Action3)(plugin, channel, remainMinutes) -> {
            this.textChannel.setTextColor(plugin.getTextColor());
            if (plugin.getTextColor() == -1) {
                this.textResponse.setTextColor(-1);
                this.textResponseDescription.setTextColor(-1);
                this.textWorkingTime.setTextColor(-1);
                this.imageWorkingTime.setColor(-1);
            } else {
                this.textResponse.setTextColor(this.darkTextColor);
                this.textResponseDescription.setTextColor(this.darkTextColor);
                this.textWorkingTime.setTextColor(this.darkTextColor);
                this.imageWorkingTime.setColor(this.darkTextColor);
            }
            Views.setVisibility(this.layoutWorkingTime, channel.hasValidWorkingTime());
            this.textChannel.setText((CharSequence)channel.getName());
            this.textResponse.setTextKey(ComponentUtils.getResponseKey(channel, remainMinutes == 0));
            this.textResponseDescription.setText(ComponentUtils.getShortResponseDescription(channel, remainMinutes));
            this.imageResponse.setImageResource(ComponentUtils.getResponseSymbol(plugin, channel, remainMinutes == 0));
            this.settingsButton.setColor(plugin.getTextColor());
            this.closeButton.setColor(plugin.getTextColor());
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
            this.binder = null;
        }
    }

    public void setLoungeHeaderInteractionListener(@Nullable LoungeHeaderInteractionListener loungeHeaderInteractionListener) {
        this.loungeHeaderInteractionListener = loungeHeaderInteractionListener;
    }
}

