package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Person;

import java.util.Map;

/**
 * Created by mika on 2017. 1. 16..
 */
public class User implements Person {

  private String id;
  @Nullable
  private String memberId;
  @Nullable
  private String name;
  @Nullable
  private String avatarUrl;
  @Nullable
  private String systemLanguage;
  @Nullable
  private Map<String, Object> profile;
  @Nullable
  private Integer alert;

  @Nullable
  private String popUpChatId;

  @Nullable
  private Boolean unsubscribed;

  @Override
  public String getId() {
    return id;
  }

  @Nullable
  public String getMemberId() {
    return memberId;
  }

  @NonNull
  @Override
  public String getName() {
    return name != null ? name : "";
  }

  @Nullable
  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  public final static String CLASSNAME = "user";

  public int getAlert() {
    if (alert != null) {
      return alert;
    }
    return 0;
  }

  @Nullable
  public Map<String, Object> getProfile() {
    return profile;
  }

  @Nullable
  public Object getProfileValue(String key) {
    if (profile != null) {
      return profile.get(key);
    } else {
      return null;
    }
  }

  @Override
  public String getPersonType() {
    return Const.USER;
  }

  @Override
  public String getPersonId() {
    return id;
  }

  @NonNull
  public CHLocale getUserLocale() {
    return CHLocale.fromString(systemLanguage);
  }

  @Nullable
  public String getPopUpChatId() {
    return popUpChatId;
  }

  @Nullable
  public boolean getUnsubscribed() {
    if (unsubscribed != null) {
      return unsubscribed;
    }
    return false;
  }
}
