/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.draw;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.zoyi.channel.plugin.android.ChannelIO;

public class Display {
    private static final double MAXIMUM_MOBILE_DISPLAY_SIZE = 6.5;

    public static int getWidth(Context context) {
        if (context instanceof Activity) {
            return Display.getWidth((Activity)context);
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        android.view.Display display = wm.getDefaultDisplay();
        Point outSize = new Point();
        display.getSize(outSize);
        return outSize.x;
    }

    public static int getWidth(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.widthPixels;
    }

    public static int getHeight(Context context) {
        if (context instanceof Activity) {
            return Display.getHeight((Activity)context);
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        android.view.Display display = wm.getDefaultDisplay();
        Point outSize = new Point();
        display.getSize(outSize);
        return outSize.y;
    }

    public static int getHeight(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.heightPixels;
    }

    public static boolean isMobile() {
        Context context = ChannelIO.getAppContext();
        if (context == null) {
            return true;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        float yInches = (float)metrics.heightPixels / metrics.ydpi;
        float xInches = (float)metrics.widthPixels / metrics.xdpi;
        double diagonalInches = Math.sqrt(xInches * xInches + yInches * yInches);
        return diagonalInches < 6.5;
    }
}

