package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.com.annimon.stream.Optional;

import java.util.List;

/**
 * Created by mika on 2018. 10. 26..
 */

public class SupportBotMessageItem extends InitMessageItem {

  @NonNull
  private SupportBotEntry supportBotEntry;

  public SupportBotMessageItem(@NonNull SupportBotEntry supportBotEntry) {
    super();

    this.supportBotEntry = supportBotEntry;
  }

  @Nullable
  public List<ActionButton> getButtons() {
    return supportBotEntry.getButtons();
  }

  @Nullable
  public List<Block> getBlocks() {
    return Optional.ofNullable(supportBotEntry)
        .map(SupportBotEntry::getStep)
        .map(Step::getMessage)
        .map(NestedMessage::getBlocks)
        .orElse(null);
  }

  @Nullable
  public List<File> getFiles() {
    return Optional.ofNullable(supportBotEntry)
        .map(SupportBotEntry::getStep)
        .map(Step::getMessage)
        .map(NestedMessage::getFiles)
        .orElse(null);
  }

  @Nullable
  public WebPage getWebPage() {
    return Optional.ofNullable(supportBotEntry)
        .map(SupportBotEntry::getStep)
        .map(Step::getMessage)
        .map(NestedMessage::getWebPage)
        .orElse(null);
  }

  @Override
  public String getSecondaryKey() {
    return "SupportBotMessageItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.SUPPORT_BOT;
  }

  public String getId() {
    return supportBotEntry.getId();
  }
}
