package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;

/**
 * Created by mika on 2016. 3. 14..
 */
public class RetrofitInterceptor implements Interceptor {
  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();

    Request.Builder builder = request.newBuilder();

    String jwt = GlobalStore.get().jwt.get();

    if (jwt != null) {
      builder.header(Const.X_SESSION, jwt);
    }

    return chain.proceed(builder.build());
  }
}
