package com.zoyi.channel.plugin.android;


import com.zoyi.channel.plugin.android.global.Const;

public enum CHLocale {
  KOREAN(Const.KOREAN),
  JAPANESE(Const.JAPANESE),
  ENGLISH(Const.ENGLISH);

  final String string;

  CHLocale(String string) {
    this.string = string;
  }

  public static CHLocale fromString(String languageCode) {
    if (languageCode == null) {
      return ENGLISH;
    }
    switch (languageCode) {
      case Const.KOREAN:
        return KOREAN;
      case Const.JAPANESE:
        return JAPANESE;
      default:
        return ENGLISH;
    }
  }

  @Override
  public String toString() {
    return string;
  }
}
