/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat3.ChatUtils;
import com.zoyi.channel.plugin.android.activity.chats.ChatsActivity;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.watermark.ChannelWatermarkView;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeAdapter;
import com.zoyi.channel.plugin.android.activity.lounge.LoungePresenter;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderInteractionListener;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderView;
import com.zoyi.channel.plugin.android.activity.settings2.SettingsActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.InAppPushStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.coordinator.LoungeCoordinatorLayout;
import com.zoyi.channel.plugin.android.view.coordinator.PaddingNestedScrollView;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.scrollview.NestedScrollViewBottomPlaceholderLayout;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;
import com.zoyi.channel.plugin.android.view.textview.EllipsizeTextView;

public class LoungeActivity
extends BaseActivity2
implements LoungeContract.View,
OnChatClickListener,
LoungeHeaderInteractionListener {
    private LoungeCoordinatorLayout layoutCoordinator;
    private LoungeHeaderView headerLounge;
    private View buttonCloseLounge;
    private View layoutPreviewHeader;
    private View layoutPreviewChat;
    private RecyclerView recyclerViewChat;
    private View buttonChatStartChats;
    private ChatStartButton buttonChatStartWelcome;
    private CHTextView textLoungeSeeMoreChats;
    private View layoutPreviewWelcome;
    private AvatarLayout avatarWelcomeMessageProfile;
    private TextView textWelcomeMessageProfile;
    private EllipsizeTextView textWelcomeMessage;
    private PaddingNestedScrollView scrollViewLounge;
    private NestedScrollViewBottomPlaceholderLayout bottomLayout;
    private ChannelWatermarkView watermark;
    private View layoutPreviewLoading;
    private ErrorRefreshView layoutPreviewError;
    private LoungeAdapter adapter;
    private LoungeContract.Presenter presenter;
    private LinearLayoutManager layoutManager;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_lounge);
        this.setOutTransition(Transition.SLIDE_FROM_BOTTOM);
        this.layoutCoordinator = (LoungeCoordinatorLayout)this.findViewById(R.id.layoutLoungeCoordinator);
        this.headerLounge = (LoungeHeaderView)this.findViewById(R.id.viewLoungeHeader);
        this.headerLounge.setLoungeHeaderInteractionListener(this);
        this.buttonCloseLounge = this.findViewById(R.id.buttonCloseLounge);
        this.buttonCloseLounge.setOnClickListener(v -> Action.invoke(ActionType.EXIT));
        this.layoutPreviewHeader = this.findViewById(R.id.viewLoungePreviewHeader);
        this.layoutPreviewChat = this.findViewById(R.id.layoutLoungePreviewChat);
        this.layoutPreviewWelcome = this.findViewById(R.id.layoutLoungePreviewWelcomeMessage);
        this.layoutPreviewWelcome.setOnClickListener(v -> this.startEmptyChat());
        this.layoutPreviewLoading = this.findViewById(R.id.layoutLoungePreviewLoader);
        this.layoutPreviewError = (ErrorRefreshView)this.findViewById(R.id.layoutLoungePreviewError);
        this.layoutPreviewError.setListener(v -> this.presenter.fetchPreviewData());
        this.avatarWelcomeMessageProfile = (AvatarLayout)this.findViewById(R.id.avatarLoungePreviewWelcomeMessage);
        this.textWelcomeMessageProfile = (TextView)this.findViewById(R.id.textLoungePreviewWelcomeMessageName);
        this.textWelcomeMessage = (EllipsizeTextView)this.findViewById(R.id.textLoungePreviewWelcomeMessageMessage);
        this.layoutCoordinator.setOnNestedScrollChangeListener((scrollPosition, headerHeight) -> {
            float maxScrollPosition = Math.min(scrollPosition, headerHeight);
            float closeButtonAlpha = maxScrollPosition / (float)headerHeight;
            this.headerLounge.setAlpha(1.0f - closeButtonAlpha);
            this.buttonCloseLounge.setAlpha(closeButtonAlpha);
            this.buttonCloseLounge.setVisibility(scrollPosition == 0 ? 8 : 0);
        });
        this.adapter = new LoungeAdapter();
        this.adapter.setListener(this);
        this.buttonChatStartChats = this.findViewById(R.id.buttonLoungePreviewChatStartChats);
        this.buttonChatStartChats.setOnClickListener(v -> this.startEmptyChat());
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.recyclerViewChat = (RecyclerView)this.findViewById(R.id.recyclerLoungePreviewChat);
        this.recyclerViewChat.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerViewChat.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerViewChat.setItemAnimator(null);
        this.recyclerViewChat.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.scrollViewLounge = (PaddingNestedScrollView)this.findViewById(R.id.scrollViewLounge);
        this.watermark = (ChannelWatermarkView)this.findViewById(R.id.watermarkLounge);
        this.bottomLayout = (NestedScrollViewBottomPlaceholderLayout)this.findViewById(R.id.bottomLayoutLounge);
        this.bottomLayout.setNestedScrollView(this.scrollViewLounge, scrollable -> this.watermark.setBackgroundVisibility(scrollable));
        this.buttonChatStartWelcome = (ChatStartButton)this.findViewById(R.id.buttonLoungePreviewChatStartWelcome);
        this.buttonChatStartWelcome.setOnClickListener(v -> this.startEmptyChat());
        this.textLoungeSeeMoreChats = (CHTextView)this.findViewById(R.id.textLoungeSeeMoreChats);
        this.textLoungeSeeMoreChats.setOnClickListener(v -> this.showChats());
        this.textLoungeSeeMoreChats.setOnTextContentChangeListener((localizeString, data) -> {
            if (data instanceof Integer && (Integer)data > 0) {
                return String.format(localizeString, Utils.getCount((Integer)data, false));
            }
            return null;
        });
        this.presenter = new LoungePresenter(this, this.adapter, this.adapter);
        this.bindPresenter(this.presenter);
        GlobalStore.get().messengerState.set(true);
        InAppPushStore.get().pushItem.set(null);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.startChat(ChatContentType.fromString(intent.getStringExtra("chatContentType")), intent.getStringExtra("chatContentId"), Transition.SLIDE_FROM_BOTTOM);
        }
        return true;
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent != null) {
            this.startChat(ChatContentType.fromString(intent.getStringExtra("chatContentType")), intent.getStringExtra("chatContentId"), Transition.SLIDE_FROM_RIGHT);
        }
    }

    @Override
    protected void onDestroy() {
        GlobalStore.get().messengerState.set(false);
        Action.invoke(ActionType.MESSENGER_CLOSED);
        super.onDestroy();
    }

    @Override
    public void onPreviewStateChange(PreviewState previewState, int invisibleChatsCount) {
        this.layoutPreviewChat.setVisibility(8);
        this.layoutPreviewHeader.setVisibility(8);
        this.layoutPreviewWelcome.setVisibility(8);
        this.layoutPreviewLoading.setVisibility(8);
        this.layoutPreviewError.setVisibility(8);
        this.buttonChatStartWelcome.setVisibility(8);
        this.textLoungeSeeMoreChats.setVisibility(8);
        switch (previewState) {
            case CHATS: {
                this.layoutPreviewHeader.setVisibility(0);
                this.layoutPreviewChat.setVisibility(0);
                Views.setVisibility((View)this.textLoungeSeeMoreChats, invisibleChatsCount > 0);
                this.textLoungeSeeMoreChats.setData(invisibleChatsCount);
                break;
            }
            case WELCOME: {
                this.layoutPreviewWelcome.setVisibility(0);
                this.buttonChatStartWelcome.setVisibility(0);
                Views.setVisibility((View)this.textLoungeSeeMoreChats, invisibleChatsCount > 0);
                this.textLoungeSeeMoreChats.setData(invisibleChatsCount);
                break;
            }
            case LOADING: {
                this.layoutPreviewLoading.setVisibility(0);
                break;
            }
            case FAILED: {
                this.layoutPreviewError.setVisibility(0);
            }
        }
    }

    @Override
    public void onDefaultProfileChange(ProfileEntity profileEntity) {
        if (profileEntity != null) {
            this.avatarWelcomeMessageProfile.set(profileEntity);
            this.textWelcomeMessageProfile.setText((CharSequence)profileEntity.getName());
        }
    }

    @Override
    public void onWelcomeMessageChange(String message) {
        if (message != null) {
            this.textWelcomeMessage.setText((CharSequence)ParseUtils.parseMessage(message));
        }
    }

    @Override
    public void onChatItemClick(@NonNull ChatItem chatItem) {
        this.startChat(chatItem.getType(), chatItem.getSubKey(), Transition.SLIDE_FROM_RIGHT);
    }

    @Override
    public void onChatItemLongClick(@NonNull ChatItem chatItem) {
        ((ChannelDialog)((Object)((ChannelDialog)((Object)((ChannelDialog)((Object)new ChannelDialog((Context)this).setDescription(ResUtils.getString("ch.chat.delete_description")).addButton(ButtonType.CANCEL))).addButton(ButtonType.OK, v -> this.presenter.removeChat(chatItem)))).allowBackpress(true))).show();
    }

    private void showChats() {
        IntentUtils.setNextActivity((Context)this, ChatsActivity.class).startActivity();
    }

    @Override
    public void onSettingsClick() {
        IntentUtils.setNextActivity((Context)this, SettingsActivity.class).startActivity();
    }

    @Override
    public void onExitClick() {
        Action.invoke(ActionType.EXIT);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 21 && resultCode == 22) {
            this.startEmptyChat(Transition.NONE);
        }
    }

    private void startEmptyChat() {
        ChatUtils.createChatActivityIntent((Activity)this).startActivityForResult(21);
    }

    private void startEmptyChat(Transition transition) {
        ChatUtils.createChatActivityIntent((Activity)this).setTransition(transition).startActivityForResult(21);
    }

    private void startChat(ChatContentType contentType, @Nullable String contentId, Transition transition) {
        if ((contentType == ChatContentType.USER_CHAT || contentType == ChatContentType.PUSH_BOT_CHAT) && contentId != null) {
            ChatUtils.createChatActivityIntent((Activity)this).putExtra("chatContentType", contentType.toString()).putExtra("chatContentId", contentId).setTransition(transition).startActivityForResult(21);
        }
    }
}

