/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.RealChannelIO;
import com.zoyi.channel.plugin.android.action.EventAction;
import com.zoyi.channel.plugin.android.action.GuestAction;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.push.ChannelPushClient;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector2.GlobalSelector;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.util.L;
import java.util.Map;

public class ChannelIO {
    private static boolean isDebugMode = false;
    @Nullable
    private static RealChannelIO realChannelIO;

    public static void initialize(@Nullable Application application) {
        if (application == null) {
            L.e("Fail to 'initialize', Application can't be NULL");
        } else if (realChannelIO != null) {
            L.e("Fail to 'initialize', Channel plugin already initialized");
        } else {
            realChannelIO = new RealChannelIO(application);
        }
    }

    public static void setDebugMode(boolean enable) {
        isDebugMode = enable;
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings) {
        ChannelIO.boot(pluginSettings, null, null);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable OnBootListener completion) {
        ChannelIO.boot(pluginSettings, null, completion);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile) {
        ChannelIO.boot(pluginSettings, profile, null);
    }

    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile, @Nullable OnBootListener completion) {
        if (realChannelIO == null) {
            L.e("Fail to 'boot', Initialize first");
            if (completion != null) {
                completion.onCompletion(ChannelPluginCompletionStatus.NOT_INITIALIZED, null);
            }
        } else if (pluginSettings == null || pluginSettings.getPluginKey() == null) {
            L.e("Fail to 'boot', Check plugin information");
            if (completion != null) {
                completion.onCompletion(ChannelPluginCompletionStatus.NOT_INITIALIZED, null);
            }
        } else {
            realChannelIO.boot(pluginSettings, profile, completion);
        }
    }

    public static void shutdown() {
        if (realChannelIO != null) {
            realChannelIO.shutdown();
        }
    }

    public static boolean open(@Nullable Context context) {
        return ChannelIO.open(context, true);
    }

    @Deprecated
    public static boolean open(@Nullable Context context, boolean animate) {
        return ChannelIO.openChat(context, null, animate);
    }

    public static void close() {
        Action.invoke(ActionType.EXIT);
    }

    @Deprecated
    public static void close(boolean animated) {
        ChannelIO.close();
    }

    public static boolean openChat(@Nullable Context context) {
        return ChannelIO.openChat(context, null);
    }

    public static boolean openChat(@Nullable Context context, @Nullable String chatId) {
        return ChannelIO.openChat(context, chatId, true);
    }

    @Deprecated
    public static boolean openChat(@Nullable Context context, @Nullable String chatId, boolean animate) {
        if (realChannelIO != null) {
            return realChannelIO.startMessenger(context, chatId, animate);
        }
        return false;
    }

    public static void show() {
        if (!SettingsStore.get().showLauncher.get().booleanValue()) {
            SettingsStore.get().showLauncher.set(true);
            if (ChannelIO.isBooted() && SettingsStore.get().enabledTrackDefaultEvent.get().booleanValue()) {
                EventAction.trackPageView();
            }
        }
    }

    public static void hide() {
        SettingsStore.get().showLauncher.set(false);
    }

    public static boolean canShowLauncher() {
        return GlobalSelector.getLauncherVisibility();
    }

    public static void setChannelPluginListener(ChannelPluginListener channelPluginListener) {
        if (realChannelIO != null) {
            realChannelIO.setListener(channelPluginListener);
        }
    }

    public static void clearChannelPluginListener() {
        if (realChannelIO != null) {
            realChannelIO.clearListener();
        }
    }

    @Nullable
    public static ChannelPluginListener getChannelPluginListener() {
        if (realChannelIO != null) {
            return realChannelIO.getListener();
        }
        return null;
    }

    public static void track(@NonNull @Size(min=1L, max=30L) String eventName) {
        ChannelIO.track(eventName, null);
    }

    public static void track(@NonNull @Size(min=1L, max=30L) String eventName, @Nullable Map<String, Object> eventProperty) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            L.e("Fail to track event. Event name can't be blank or null.");
            return;
        }
        if (eventName.length() > 30) {
            L.e("Fail to track event. Event name must be 30 characters or less.");
            return;
        }
        Plugin plugin = PluginStore.get().pluginState.get();
        if (plugin == null || plugin.getId() == null) {
            L.e("Fail to track event. Unauthorized access.");
            return;
        }
        EventAction.track(new Event(eventName, eventProperty));
    }

    public static void initPushToken(String token) {
        Context context = ChannelIO.getAppContext();
        if (context != null) {
            PrefSupervisor.setDeviceToken(context, token);
        }
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(message);
    }

    public static void handlePushNotification(Activity activity) {
        if (activity != null) {
            ChannelPushClient.handlePushNotification((Context)activity);
        }
    }

    public static void showPushNotification(Context context, Map<String, String> message) {
        if (context != null) {
            ChannelPushManager.showPushNotification(context, message);
        }
    }

    public static void updateProfile(Map<String, Object> profileMap) {
        if (ChannelIO.isBooted()) {
            GuestAction.updateGuest(profileMap, null, null);
        }
    }

    public static boolean isInitializedChannelIO() {
        return realChannelIO != null;
    }

    @Nullable
    public static Context getAppContext() {
        if (realChannelIO != null) {
            return realChannelIO.getApplication();
        }
        return null;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static boolean isBooted() {
        return PluginStore.get().pluginState.get() != null;
    }
}

