package com.zoyi.channel.plugin.android.network;

/**
 * Created by mika on 2016. 5. 11..
 */

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.rx.Subscriber;

public class RestSubscriber<E> extends Subscriber<E> {

  @Nullable
  private ActionType actionType;

  @Nullable
  private ActionType[] cancelTypes;

  public void setActionSubscription(@Nullable ActionType actionType, @Nullable ActionType... cancelTypes) {
    this.actionType = actionType;
    this.cancelTypes = cancelTypes;
  }

  @Override
  public void onCompleted() {

  }

  @Override
  public void onError(Throwable e) {
    try {
      RetrofitException retrofitException = RetrofitException.createException(e);
      L.e("Rest onError : " + retrofitException.getMessage());
      retrofitException.printStackTrace();

      onError(retrofitException);
    } catch (Exception ex) { }

    Action.removeSubscriber(this);
  }

  public void onError(RetrofitException error) { }

  @Override
  public void onNext(E e) {
    if (e != null) {
      onSuccess(e);
    } else {
      onSuccessWithNull();
    }

    Action.removeSubscriber(this);
  }

  public void onSuccessWithNull() {

  }

  public void onSuccess(@NonNull E e) {

  }

  @Nullable
  public ActionType getActionType() {
    return actionType;
  }

  @NonNull
  public ActionType[] getCancelTypes() {
    if (cancelTypes != null) {
      return cancelTypes;
    }
    return new ActionType[]{};
  }
}
