/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.channel.plugin.android.model.rest.WorkingTime;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class Channel
implements Entity,
ProfileEntity {
    public static final String EXPECTED_RESPONSE_DELAY_INSTANT = "instant";
    public static final String EXPECTED_RESPONSE_DELAY_NORMAL = "normal";
    public static final String EXPECTED_RESPONSE_DELAY_DELAYED = "delayed";
    public static final String PLAN_PRO = "pro";
    private String id;
    private String name;
    private String domain;
    private String description;
    private String timeZone;
    private WorkingTime workingTime;
    private TimeRange lunchTime;
    private String homepageUrl;
    private String phoneNumber;
    private String messengerPlan;
    private String pushBotPlan;
    private String supportBotPlan;
    private Boolean blocked;
    private Boolean requestGuestInfo;
    private String expectedResponseDelay;
    private String workingType;
    private String awayOption;
    private Boolean trial;
    private String avatarUrl;
    private String utcOffset;
    private String defaultPluginId;
    public static final String CLASSNAME = "Channel";

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name != null ? this.name : "";
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAwayOption() {
        return this.awayOption;
    }

    public String getWorkingType() {
        return this.workingType;
    }

    @Override
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getWorkingTimeText(Context context) {
        String launch;
        String string2 = launch = this.lunchTime != null ? String.format("%s: %s", ResUtils.getString(context, "ch.out_of_work.lunch_time"), TimeUtils.getTimeRangeString(this.lunchTime)) : null;
        if (this.workingTime != null) {
            String work = this.workingTime.getMessage(context);
            if (launch != null) {
                return String.format("Timezone: %s\n\n%s\n\n%s", this.timeZone, work, launch);
            }
            return String.format("Timezone: %s\n\n%s", this.timeZone, work);
        }
        return "";
    }

    @Nullable
    public WorkingTime getWorkingTime() {
        if ("custom".equals(this.workingType)) {
            return this.workingTime;
        }
        return null;
    }

    public TimeRange getLunchTime() {
        return this.lunchTime;
    }

    public long getUtcOffsetMinutes() {
        try {
            String[] split = this.utcOffset.split(":");
            long hours = Long.valueOf(split[0]);
            long minutes = Long.valueOf(split[1]);
            int sign = hours < 0L ? -1 : 1;
            return (hours * (long)sign * 60L + minutes) * (long)sign;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getMessengerPlan() {
        return this.messengerPlan;
    }

    public String getPushBotPlan() {
        return this.pushBotPlan;
    }

    public String getSupportBotPlan() {
        return this.supportBotPlan;
    }

    public boolean isRequestGuestInfo() {
        return this.requestGuestInfo;
    }

    public String getExpectedResponseDelay() {
        return this.expectedResponseDelay;
    }

    public boolean isTrial() {
        if (this.trial == null) {
            return false;
        }
        return this.trial;
    }

    public boolean isProMessengerPlan() {
        return PLAN_PRO.equals(this.getMessengerPlan());
    }

    public boolean canUseMobileSdk() {
        return this.blocked == false && (this.isTrial() || this.isProMessengerPlan());
    }

    public String getDefaultPluginId() {
        return this.defaultPluginId;
    }
}

