/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.common.userchat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;

public class ChatHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    @Nullable
    private OnChatClickListener listener;
    @Nullable
    private ChatItem chatItem;
    private AvatarLayout avatar;
    private CHTextView textName;
    private CHTextView textMessage;
    private CHTextView textTime;
    private CHTextView textBadge;

    @Initializer
    public ChatHolder(View itemView, @Nullable OnChatClickListener listener) {
        super(itemView);
        this.listener = listener;
        this.avatar = (AvatarLayout)itemView.findViewById(R.id.avatar_single);
        this.avatar.setTextSize(16);
        this.textName = (CHTextView)itemView.findViewById(R.id.text_name);
        this.textMessage = (CHTextView)itemView.findViewById(R.id.text_message);
        this.textTime = (CHTextView)itemView.findViewById(R.id.text_time);
        this.textBadge = (CHTextView)itemView.findViewById(R.id.text_badge);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    public void bind(ChatItem chatItem) {
        this.chatItem = chatItem;
        this.avatar.set(chatItem.getProfile());
        this.textName.setText(chatItem.getProfile() != null ? chatItem.getProfile().getName() : "");
        int alert = chatItem.getCount();
        Views.setVisibility((View)this.textBadge, alert > 0, 4);
        this.textBadge.setText(Utils.getCount(alert, true));
        this.textTime.setText(TimeUtils.get(chatItem.getUpdatedAt()));
        this.textMessage.setText((CharSequence)ParseUtils.parseMessage(chatItem.getMessage()));
        this.textMessage.setTextColor(ResUtils.getColor(chatItem.isActive() ? R.color.ch_dark : R.color.ch_light));
    }

    public void onClick(View v) {
        if (this.listener != null && this.chatItem != null) {
            this.listener.onChatItemClick(this.chatItem);
        }
    }

    public boolean onLongClick(View v) {
        if (this.listener != null && this.chatItem != null) {
            this.listener.onChatItemLongClick(this.chatItem);
        }
        return true;
    }

    public static ChatHolder newInstance(ViewGroup parent, @Nullable OnChatClickListener listener) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View itemView = inflater.inflate(R.layout.ch_plugin_item_chat, parent, false);
        return new ChatHolder(itemView, listener);
    }
}

