package com.zoyi.channel.plugin.android.view.toast;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.selector2.SocketSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;

public class SocketErrorToast extends LinearLayout {

  @Nullable
  private Binder binder;

  public SocketErrorToast(@NonNull Context context) {
    super(context);
    init(context);
  }

  public SocketErrorToast(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public SocketErrorToast(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Override
  protected void onDetachedFromWindow() {
    if (binder != null) {
      binder.unbind();
      binder = null;
    }
    super.onDetachedFromWindow();
  }

  @Initializer
  private void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_socket_error_toast, this, true);
    root.findViewById(R.id.buttonSocketErrorToastRefresh).setOnClickListener(v -> SocketManager.connect());

    binder = SocketSelector.bindSocket(socketStatus -> Views.setVisibility(root, socketStatus == SocketStatus.ERROR));
  }
}
