/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.common.watermark;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector2.ChannelSelector;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.functions.Action2;

public class ChannelWatermarkView
extends FrameLayout {
    private Context context;
    private View root;
    private CardView background;
    @Nullable
    private Binder binder;
    @Nullable
    private String link;

    public ChannelWatermarkView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        this.root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_channel_watermark, (ViewGroup)this, true);
        this.background = (CardView)this.root.findViewById(R.id.cardChannelWatermark);
        this.root.setBackgroundColor(0);
        this.root.setOnClickListener(v -> {
            if (this.link != null) {
                IntentUtils.setUrl(this.context, this.link).startActivity();
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.binder = ChannelSelector.bindWaterMark((Action2<Channel, Plugin>)((Action2)(channel, plugin) -> {
            this.root.setVisibility(channel.isTrial() || plugin.isShowPoweredBy() ? 0 : 8);
            this.link = String.format("https://channel.io/%s/?utm_source=%s&utm_medium=plugin&utm_campaign=android&utm_content=%s&utm_channel_id=%s", ((CHLocale)((Object)((Object)SettingsStore.get().locale.get()))).toString(), "plugin_watermark", channel.getName(), channel.getId());
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
        }
    }

    public void setBackgroundVisibility(boolean visibility) {
        if (visibility) {
            this.background.setCardBackgroundColor(ResUtils.getColor(R.color.ch_pale_grey_two));
            this.background.setCardElevation(Utils.dpToPx(4.0f));
        } else {
            this.background.setCardBackgroundColor(0);
            this.background.setCardElevation(0.0f);
        }
    }
}

