/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat3.navigation;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.selector2.ChatsSelector;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.button.ThemeEffectiveView;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.rx.functions.Action2;

public class HostHeaderView
extends LinearLayout
implements ThemeEffectiveView {
    private AvatarLayout avatar;
    private View onlineBadge;
    private View offlineBadge;
    private TextView textHost;
    @Nullable
    private Binder binder;

    public HostHeaderView(Context context) {
        super(context);
        this.init(context);
    }

    public HostHeaderView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public HostHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_navigation_host, (ViewGroup)this, true);
        this.avatar = (AvatarLayout)view.findViewById(R.id.avatarChatNavigationHost);
        this.onlineBadge = view.findViewById(R.id.badgeChatNavigationHostOnline);
        this.offlineBadge = view.findViewById(R.id.badgeChatNavigationHostOffline);
        this.textHost = (TextView)view.findViewById(R.id.textChatNavigationHostName);
    }

    public void attachUserChat(@Nullable String chatId) {
        if (this.binder == null) {
            this.binder = ChatsSelector.binderHost(chatId, (Action2<ProfileEntity, Boolean>)((Action2)(profile, online) -> {
                if (profile != null) {
                    this.avatar.set((ProfileEntity)profile);
                    this.textHost.setText((CharSequence)profile.getName());
                }
                this.onlineBadge.setVisibility(online != null && online != false ? 0 : 4);
                this.offlineBadge.setVisibility(online != null && online == false ? 0 : 4);
            }));
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
            this.binder = null;
        }
    }

    @Override
    public void onThemeChange(int backColor, int textColor) {
        this.textHost.setTextColor(textColor);
    }
}

