/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat3;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.DateItem;
import com.zoyi.channel.plugin.android.activity.chat.model.InitMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.LogMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.NewMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.PushBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.TypingItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ChatMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.DateDividerHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.LogMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.NewMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.PushBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SendingMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SupportBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TypingHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.WelcomeMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat3.contract.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat3.listener.OnProfileUpdateRequestListener;
import com.zoyi.channel.plugin.android.activity.chat3.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat3.viewholder.ProfileBotMessageHolder;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChatAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ChatAdapterContract.View,
ChatAdapterContract.Model {
    private SortedList<MessageItem> items = new SortedList(MessageItem.class, new SortedListCallback(this, false));
    @Nullable
    private OnProfileUpdateRequestListener onProfileUpdateRequestListener;
    @Nullable
    private OnMessageContentClickListener onMessageContentClickListener;
    @NonNull
    private TypingItem typingItem = new TypingItem();
    @Nullable
    private InitMessageItem initMessageItem = null;
    @Nullable
    private DateItem initDateItem = null;

    public ChatAdapter() {
        this.items.add((Object)this.typingItem);
    }

    public void setOnProfileUpdateRequestListener(@Nullable OnProfileUpdateRequestListener onProfileUpdateRequestListener) {
        this.onProfileUpdateRequestListener = onProfileUpdateRequestListener;
    }

    public void setOnMessageContentClickListener(@Nullable OnMessageContentClickListener onMessageContentClickListener) {
        this.onMessageContentClickListener = onMessageContentClickListener;
    }

    @Override
    public void setInitMessage(InitMessageItem item) {
        if (item != null && this.initMessageItem == null) {
            this.initMessageItem = item;
            this.initDateItem = new DateItem(item.getCreatedAt());
            this.items.beginBatchedUpdates();
            this.items.add((Object)item);
            this.items.add((Object)this.initDateItem);
            this.items.endBatchedUpdates();
        }
    }

    @Override
    public void setMessages(Collection<Message> messages, Collection<SendingMessageItem> unsentItems, @Nullable Session lastReadSession) {
        List<MessageItem> newItems = this.purifyMessages(messages, lastReadSession);
        newItems.add(this.typingItem);
        newItems.addAll(unsentItems);
        this.items.replaceAll(newItems);
    }

    @Override
    public void replaceInitMessageItem(Message message) {
        if (this.initMessageItem != null) {
            this.items.remove((Object)this.initMessageItem);
        }
        if (this.initDateItem != null) {
            this.items.remove((Object)this.initDateItem);
        }
        if (message != null) {
            this.addMessages(Collections.singleton(message), null);
        }
    }

    @Override
    public void addMessages(Collection<Message> messages, @Nullable Session lastReadSession) {
        List<MessageItem> newItems = this.purifyMessages(messages, lastReadSession);
        this.items.beginBatchedUpdates();
        for (MessageItem item : newItems) {
            this.items.add((Object)item);
        }
        for (Message message : messages) {
            SendingMessageItem item;
            if (message == null || !CompareUtils.exists((Comparable)((Object)message.getPersonType()), (Comparable[])new String[]{"User", "Veil"}) || (item = SendingMessageItem.createDummy(message.getRequestId())) == null) continue;
            this.items.remove((Object)item);
        }
        this.items.endBatchedUpdates();
    }

    @Override
    public void addMessage(Message message) {
        this.addMessages(Collections.singleton(message), null);
    }

    @NonNull
    private List<MessageItem> purifyMessages(Collection<Message> messages, @Nullable Session session) {
        ArrayList<MessageItem> newItems = new ArrayList<MessageItem>();
        long minTimestamp = Long.MAX_VALUE;
        long maxTimestamp = Long.MIN_VALUE;
        for (Message message : messages) {
            if (message == null) continue;
            minTimestamp = Math.min(minTimestamp, message.getCreatedAt());
            maxTimestamp = Math.max(maxTimestamp, message.getCreatedAt());
            if (message.getLog() != null && !message.isDeleted()) continue;
            newItems.add(new ChatMessageItem(message));
            newItems.add(new DateItem(message.getCreatedAt()));
            if (message.getProfileBot() == null) continue;
            newItems.add(new ProfileBotMessageItem(message));
        }
        if (session != null && session.getReadAt() != null && minTimestamp < session.getReadAt() && session.getReadAt() < maxTimestamp) {
            newItems.add(new NewMessageItem(session.getReadAt()));
        }
        return newItems;
    }

    @Override
    public void addMessageItem(MessageItem item) {
        this.items.add((Object)item);
    }

    @Override
    public void addMessageItems(Collection<? extends MessageItem> items) {
        this.items.addAll(items);
    }

    @Override
    public void removeMessageItem(MessageItem item) {
        this.items.remove((Object)item);
    }

    @Override
    public void setTypings(List<Typing> typings) {
        this.addMessageItem(this.typingItem.setTypings(typings));
    }

    @Override
    public void replaceMessageItem(MessageItem newItem, MessageItem oldItem) {
        this.items.beginBatchedUpdates();
        this.items.remove((Object)oldItem);
        this.items.add((Object)newItem);
        this.items.endBatchedUpdates();
    }

    @Nullable
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        MessageType type = MessageType.fromId(viewType);
        switch (type) {
            case NEW_MESSAGE_DIVIDER: {
                return NewMessageHolder.newInstance(parent);
            }
            case TYPING: {
                return TypingHolder.newInstance(parent);
            }
            case DATE: {
                return DateDividerHolder.newInstance(parent);
            }
            case LOG: {
                return LogMessageHolder.newInstance(parent);
            }
            case SENDING: {
                return SendingMessageHolder.newInstance(parent, type, this.onMessageContentClickListener);
            }
            case HOST: 
            case GUEST: {
                return ChatMessageHolder.newInstance(parent, type, this.onMessageContentClickListener);
            }
            case PROFILE_BOT: {
                return ProfileBotMessageHolder.newInstance(parent, this.onProfileUpdateRequestListener);
            }
            case WELCOME: {
                return WelcomeMessageHolder.newInstance(parent);
            }
            case SUPPORT_BOT: {
                return SupportBotMessageHolder.newInstance(parent, this.onMessageContentClickListener);
            }
            case PUSH_BOT: {
                return PushBotMessageHolder.newInstance(parent, this.onMessageContentClickListener);
            }
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        MessageItem item = (MessageItem)this.items.get(position);
        switch (item.getType()) {
            case TYPING: {
                TypingHolder typingHolder = (TypingHolder)holder;
                typingHolder.bind((TypingItem)item);
                break;
            }
            case DATE: {
                DateDividerHolder dateDividerHolder = (DateDividerHolder)holder;
                dateDividerHolder.bind((DateItem)item);
                break;
            }
            case LOG: {
                LogMessageHolder logMessageHolder = (LogMessageHolder)holder;
                logMessageHolder.bind((LogMessageItem)item);
                break;
            }
            case SENDING: {
                SendingMessageItem sendingMessageItem = (SendingMessageItem)item;
                SendingMessageHolder sendingHolder = (SendingMessageHolder)holder;
                sendingHolder.bind((SendingMessageItem)item, sendingMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case HOST: 
            case GUEST: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                ChatMessageHolder chatMessageHolder = (ChatMessageHolder)holder;
                chatMessageHolder.bind(chatMessageItem, chatMessageItem.isConnected(this.getItem(position - 1)), this.isLastPosition(position));
                break;
            }
            case PROFILE_BOT: {
                ProfileBotMessageItem profileItem = (ProfileBotMessageItem)item;
                ProfileBotMessageHolder profileBotMessageHolder = (ProfileBotMessageHolder)holder;
                profileBotMessageHolder.bind(profileItem);
                break;
            }
            case WELCOME: {
                WelcomeMessageItem welcomeMessageItem = (WelcomeMessageItem)item;
                WelcomeMessageHolder welcomeMessageHolder = (WelcomeMessageHolder)holder;
                welcomeMessageHolder.bind(welcomeMessageItem);
                break;
            }
            case SUPPORT_BOT: {
                SupportBotMessageItem supportBotMessageItem = (SupportBotMessageItem)item;
                SupportBotMessageHolder supportBotMessageHolder = (SupportBotMessageHolder)holder;
                supportBotMessageHolder.bind(supportBotMessageItem, this.isLastPosition(position));
                break;
            }
            case PUSH_BOT: {
                PushBotMessageItem pushBotMessageItem = (PushBotMessageItem)item;
                PushBotMessageHolder pushBotMessageHolder = (PushBotMessageHolder)holder;
                pushBotMessageHolder.bind(pushBotMessageItem);
            }
        }
    }

    @Nullable
    private MessageItem getItem(int position) {
        if (position >= 0 && position < this.items.size()) {
            return (MessageItem)this.items.get(position);
        }
        return null;
    }

    private boolean isLastPosition(int position) {
        return position == this.getItemCount() - 2;
    }

    public int getItemViewType(int position) {
        return ((MessageItem)this.items.get(position)).getType().toInt();
    }

    @Override
    public int getItemCount() {
        return this.items.size();
    }

    @Override
    @Nullable
    public Long getLastMessageItemKey() {
        MessageItem item = this.getItem(this.getItemCount() - 2);
        if (item != null) {
            return item.getPrimaryKey();
        }
        return null;
    }

    @Override
    @Nullable
    public Message getLastMessage() {
        for (int i = this.getItemCount(); i >= 0; --i) {
            MessageItem item = this.getItem(i);
            if (item == null || item.getType() != MessageType.HOST) continue;
            return ((ChatMessageItem)item).getMessage();
        }
        return null;
    }
}

