package com.zoyi.channel.plugin.android.activity.lounge;

import com.zoyi.channel.plugin.android.action.*;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeAdapterContract;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector2.*;
import com.zoyi.channel.plugin.android.store2.*;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class LoungePresenter
    extends AbstractAdapterPresenter<LoungeContract.View, LoungeAdapterContract.View, LoungeAdapterContract.Model>
    implements LoungeContract.Presenter {

  public LoungePresenter(
      LoungeContract.View view,
      LoungeAdapterContract.View adapterView,
      LoungeAdapterContract.Model adapterModel
  ) {
    super(view, adapterView, adapterModel);
  }

  // Fetch methods

  @Override
  public void fetchBundleData() {
    fetchPreviewData();
    fetchOperators();
    ChannelAction.fetchMessengers();
  }

  @Override
  public void fetchPreviewData() {
    fetchUserChats(SettingsStore.get().showClosedChat.get());
    fetchPlugin();
    fetchSupportBot();
    fetchChannel();
  }

  private void fetchOperators() {
    ManagerAction.fetchOperators();
  }

  private void fetchUserChats(boolean showClosedChats) {
    UserChatAction.fetchUserChats(showClosedChats);
  }

  private void fetchChannel() {
    ChannelAction.fetchChannel();
  }

  private void fetchPlugin() {
    Plugin plugin = Store2.getInstance(PluginStore.class).pluginState.get();

    if (plugin != null) {
      PluginAction.fetchPlugin(plugin.getId(), true);
    }
  }

  private void fetchSupportBot() {
    Plugin plugin = Store2.getInstance(PluginStore.class).pluginState.get();

    if (plugin != null) {
      SupportBotAction.fetchSupportBot(plugin.getId(), true);
    }
  }

  // bind

  @Override
  public void init() {
    if (SocketStore.get().socketState.get() != SocketStatus.READY) {
      view.onPreviewStateChange(PreviewState.FAILED, 0);
    }

    bind(LoungeSelector.bindPreviewState((previewState, invisibleChatsCount) ->
        view.onPreviewStateChange(previewState, invisibleChatsCount))
    );

    bind(ProfileSelector.bindDefaultProfile(profile -> view.onDefaultProfileChange(profile)));

    bind(LoungeSelector.bindWelcomeMessage(message -> view.onWelcomeMessageChange(message)));

    bind(SettingsSelector.bindShowClosedChats(showClosedChats -> {
      if (showClosedChats != null) {
        fetchUserChats(showClosedChats);
      }
    }));

    bind(ChatsSelector.bindChats((activeChatItems, closedChatItems) -> adapterModel.updateChatItems(activeChatItems)));

    bind(SocketSelector.bindSocket(socketStatus -> {
      if (socketStatus == SocketStatus.READY) {
        fetchBundleData();
      }
    }));
  }

  @Override
  public void removeChat(ChatItem item) {
    if (item instanceof PushBotChatItem) {
      PushBotItem pushBotItem = PushBotStore.get().pushBots.get(item.getId());

      if (pushBotItem != null) {
        pushBotItem.remove();

        PushBotStore.get().pushBots.upsert(pushBotItem);
      }
    }
    if (item instanceof UserChatItem) {
      view.showProgress(ResUtils.getString("ch.chat.delete_progress"));

      ChatAction.removeUserChat(
          item.getId(),
          () -> {
            view.hideProgress();
            UserChatStore.get().userChats.removeByKey(item.getId());
          },
          () -> view.hideProgress()
      );
    }
  }
}
