/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_album;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import java.util.List;

public class PhotoAlbumPagerAdapter
extends PagerAdapter {
    private Context context;
    private PhotoViewAttacher.OnPhotoTapListener listener;
    private LayoutInflater inflater;
    @NonNull
    private List<FileMeta> filemetas;

    public PhotoAlbumPagerAdapter(Context context, @NonNull List<FileMeta> filemetas, PhotoViewAttacher.OnPhotoTapListener listener) {
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
        this.filemetas = filemetas;
        this.listener = listener;
    }

    @Nullable
    public FileMeta getItem(int position) {
        if (position >= 0 && position < this.filemetas.size()) {
            return this.filemetas.get(position);
        }
        return null;
    }

    public int getCount() {
        return this.filemetas.size();
    }

    public int getItemPosition(Object item) {
        return -2;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (container != null && object != null && object instanceof View) {
            container.removeView((View)object);
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        FileMeta fileMeta = this.filemetas.get(position);
        View view = this.inflater.inflate(R.layout.ch_plugin_item_photo_album, container, false);
        PhotoView photoView = (PhotoView)view.findViewById(R.id.iv_accessary_image);
        photoView.setOnPhotoTapListener(this.listener);
        Glide.with((Context)this.context).load(fileMeta.getUrl()).diskCacheStrategy(DiskCacheStrategy.SOURCE).dontAnimate().into((ImageView)photoView);
        container.addView(view);
        return view;
    }
}

