/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge;

import com.zoyi.channel.plugin.android.action.ChannelAction;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.action.ManagerAction;
import com.zoyi.channel.plugin.android.action.PluginAction;
import com.zoyi.channel.plugin.android.action.SupportBotAction;
import com.zoyi.channel.plugin.android.action.UserChatAction;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeAdapterContract;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector2.ChatsSelector;
import com.zoyi.channel.plugin.android.selector2.LoungeSelector;
import com.zoyi.channel.plugin.android.selector2.ProfileSelector;
import com.zoyi.channel.plugin.android.selector2.SettingsSelector;
import com.zoyi.channel.plugin.android.selector2.SocketSelector;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.SocketStore;
import com.zoyi.channel.plugin.android.store2.UserChatStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import java.util.List;

public class LoungePresenter
extends AbstractAdapterPresenter<LoungeContract.View, LoungeAdapterContract.View, LoungeAdapterContract.Model>
implements LoungeContract.Presenter {
    public LoungePresenter(LoungeContract.View view, LoungeAdapterContract.View adapterView, LoungeAdapterContract.Model adapterModel) {
        super(view, adapterView, adapterModel);
    }

    @Override
    public void fetchBundleData() {
        this.fetchPreviewData();
        this.fetchFollowingManagers();
        ChannelAction.fetchMessengers();
    }

    @Override
    public void fetchPreviewData() {
        this.fetchUserChats(SettingsStore.get().showClosedChat.get());
        this.fetchPlugin();
        this.fetchSupportBot();
        this.fetchChannel();
    }

    private void fetchFollowingManagers() {
        ManagerAction.fetchFollowingManagers();
    }

    private void fetchUserChats(boolean showClosedChats) {
        UserChatAction.fetchUserChats(showClosedChats);
    }

    private void fetchChannel() {
        ChannelAction.fetchChannel();
    }

    private void fetchPlugin() {
        Plugin plugin = Store2.getInstance(PluginStore.class).pluginState.get();
        if (plugin != null) {
            PluginAction.fetchPlugin(plugin.getId(), true);
        }
    }

    private void fetchSupportBot() {
        Plugin plugin = Store2.getInstance(PluginStore.class).pluginState.get();
        if (plugin != null) {
            SupportBotAction.fetchSupportBot(plugin.getId(), true);
        }
    }

    @Override
    public void init() {
        if (SocketStore.get().socketState.get() != SocketStatus.READY) {
            ((LoungeContract.View)this.view).onPreviewStateChange(PreviewState.FAILED, 0);
        }
        this.bind(LoungeSelector.bindPreviewState((Action2<PreviewState, Integer>)((Action2)(previewState, invisibleChatsCount) -> ((LoungeContract.View)this.view).onPreviewStateChange((PreviewState)((Object)previewState), (int)invisibleChatsCount))));
        this.bind(ProfileSelector.bindDefaultProfile((Action1<ProfileEntity>)((Action1)profile -> ((LoungeContract.View)this.view).onDefaultProfileChange((ProfileEntity)profile))));
        this.bind(LoungeSelector.bindWelcomeMessage((Action1<String>)((Action1)message -> ((LoungeContract.View)this.view).onWelcomeMessageChange((String)message))));
        this.bind(SettingsSelector.bindShowClosedChats((Action1<Boolean>)((Action1)showClosedChats -> {
            if (showClosedChats != null) {
                this.fetchUserChats((boolean)showClosedChats);
            }
        })));
        this.bind(ChatsSelector.bindChats((Action2<List<ChatItem>, List<ChatItem>>)((Action2)(activeChatItems, closedChatItems) -> ((LoungeAdapterContract.Model)this.adapterModel).updateChatItems((List<ChatItem>)activeChatItems))));
        this.bind(SocketSelector.bindSocket((Action1<SocketStatus>)((Action1)socketStatus -> {
            if (socketStatus == SocketStatus.READY) {
                this.fetchBundleData();
            }
        })));
    }

    @Override
    public void removeChat(ChatItem item) {
        PushBotItem pushBotItem;
        if (item instanceof PushBotChatItem && (pushBotItem = (PushBotItem)PushBotStore.get().pushBots.get(item.getId())) != null) {
            pushBotItem.remove();
            PushBotStore.get().pushBots.upsert(pushBotItem);
        }
        if (item instanceof UserChatItem) {
            ((LoungeContract.View)this.view).showProgress(ResUtils.getString("ch.chat.delete_progress"));
            ChatAction.removeUserChat(item.getId(), () -> {
                ((LoungeContract.View)this.view).hideProgress();
                UserChatStore.get().userChats.removeByKey(item.getId());
            }, () -> ((LoungeContract.View)this.view).hideProgress());
        }
    }
}

