package com.zoyi.channel.plugin.android.view.scrollview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.View;

public class NestedScrollViewBottomPlaceholderLayout extends BottomPlaceholderLayout<NestedScrollView> {

  public NestedScrollViewBottomPlaceholderLayout(Context context) {
    super(context);
  }

  public NestedScrollViewBottomPlaceholderLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public NestedScrollViewBottomPlaceholderLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  public void setNestedScrollView(@Nullable NestedScrollView nestedScrollView) {
    setScrollableView(nestedScrollView, null);
  }

  public void setNestedScrollView(
      @Nullable NestedScrollView nestedScrollView,
      @Nullable OnScrollableStateChangeListener onScrollableStateChangeListener
  ) {
    setScrollableView(nestedScrollView, onScrollableStateChangeListener);
  }

  @Override
  protected boolean canScroll(NestedScrollView nestedScrollView, int height) {
    View child = nestedScrollView.getChildAt(0);

    if (child != null) {
      return height < child.getHeight() + nestedScrollView.getPaddingTop() + nestedScrollView.getPaddingBottom();
    }
    return false;
  }

  @Override
  protected boolean isOnBottom(NestedScrollView scrollableView) {
    return false;
  }

  @Override
  protected void scrollToBottom(NestedScrollView scrollableView) {
  }
}
