package com.zoyi.channel.plugin.android.store2.binder;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.store2.state.BaseState;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action2;

public class Binder2<E, F> extends Binder {

  private BaseState<E> state1;
  private BaseState<F> state2;

  @Nullable
  private Subscription subscription1;
  @Nullable
  private Subscription subscription2;

  public Binder2(BaseState<E> state1, BaseState<F> state2) {
    this.state1 = state1;
    this.state2 = state2;
  }

  public Binder2 bind(Action2<E, F> action2) {
    this.subscription1 = this.state1.attach(e -> action2.call(e, state2.get()));
    this.subscription2 = this.state2.attach(f -> action2.call(state1.get(), f));

    action2.call(state1.get(), state2.get());

    return this;
  }

  @Override
  public void unbind() {
    if (subscription1 != null && !subscription1.isUnsubscribed()) {
      subscription1.unsubscribe();
    }
    if (subscription2 != null && !subscription2.isUnsubscribed()) {
      subscription2.unsubscribe();
    }
    subscription1 = null;
    subscription2 = null;
  }
}
