/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import java.io.File;

public class FileUtils {
    public static boolean createDirectory(File dir) {
        boolean created;
        return dir.exists() || (created = dir.mkdirs());
    }

    public static boolean deleteFile(File file) {
        return file.exists() && file.delete();
    }

    public static boolean hasFileExtension(String path) {
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String ext = mimeTypeMap.getMimeTypeFromExtension(FilenameUtils.getExtension(path.toLowerCase()));
        return !TextUtils.isEmpty((CharSequence)ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getRealPathFromURI(Context context, Uri contentUri) {
        String path = null;
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            if (cursor != null) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                path = cursor.getString(column_index);
            }
        }
        return path;
    }

    public static File getPhotoDirectory() {
        File dir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), "ChannelPlugin");
        if (dir != null && !dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }
}

