/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.global;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.subjects.PublishSubject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Action {
    private static PublishSubject<ActionType> publishSubject = PublishSubject.create();
    private static Map<ActionType, RestSubscriber<?>> apiSubscribers = new ConcurrentHashMap();
    private static Map<ActionType, Set<RestSubscriber>> canceller = new ConcurrentHashMap<ActionType, Set<RestSubscriber>>();
    @Nullable
    private static Action action;

    private <E> void apiSubscribeInternal(Observable<E> observable, RestSubscriber<E> subscriber, @Nullable ActionType targetActionType, @Nullable ActionType[] cancelActionTypes) {
        observable.subscribe(subscriber);
        subscriber.setActionSubscription(targetActionType, cancelActionTypes);
        if (targetActionType != null) {
            this.cancelInternal(targetActionType);
            apiSubscribers.put(targetActionType, subscriber);
        }
        if (cancelActionTypes != null) {
            for (ActionType cancelType : cancelActionTypes) {
                Set<RestSubscriber> cancelSet;
                if (canceller.get((Object)cancelType) == null) {
                    canceller.put(cancelType, new HashSet());
                }
                Set<RestSubscriber> set = cancelSet = canceller.containsKey((Object)cancelType) ? canceller.get((Object)cancelType) : null;
                if (cancelSet == null) continue;
                cancelSet.add(subscriber);
            }
        }
    }

    private void cancelInternal(ActionType actionType) {
        Set<RestSubscriber> cancelSet;
        RestSubscriber<?> subscriber;
        if (apiSubscribers != null && (subscriber = apiSubscribers.get((Object)actionType)) != null) {
            if (!subscriber.isUnsubscribed()) {
                subscriber.unsubscribe();
            }
            if (canceller != null && subscriber.getCancelTypes().length > 0) {
                for (ActionType cancelType : subscriber.getCancelTypes()) {
                    Set<RestSubscriber> cancelSet2 = canceller.get((Object)cancelType);
                    if (cancelSet2 == null) continue;
                    cancelSet2.remove(subscriber);
                }
            }
            apiSubscribers.remove((Object)actionType);
        }
        if (canceller != null && (cancelSet = canceller.get((Object)actionType)) != null) {
            for (RestSubscriber subscriber2 : cancelSet) {
                if (subscriber2 == null) continue;
                if (!subscriber2.isUnsubscribed()) {
                    subscriber2.unsubscribe();
                }
                if (subscriber2.getActionType() == null) continue;
                apiSubscribers.remove((Object)subscriber2.getActionType());
            }
            cancelSet.clear();
        }
    }

    private void invokeInternal(ActionType actionType) {
        this.cancelInternal(actionType);
        if (publishSubject != null) {
            publishSubject.onNext((Object)actionType);
        }
    }

    private boolean isRunningInternal(ActionType actionType) {
        if (apiSubscribers.containsKey((Object)actionType)) {
            Subscription subscription = (Subscription)apiSubscribers.get((Object)actionType);
            return subscription != null && !subscription.isUnsubscribed();
        }
        return false;
    }

    private Observable<ActionType> observableInternal() {
        return publishSubject.onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread());
    }

    private void removeSubscriberInternal(RestSubscriber<?> subscriber) {
        if (subscriber.getActionType() != null) {
            apiSubscribers.remove((Object)subscriber.getActionType());
        }
        if (subscriber.getCancelTypes().length > 0) {
            Stream.of((Object[])subscriber.getCancelTypes()).forEach(actionType -> {
                Set<RestSubscriber> set = canceller.get(actionType);
                if (set != null) {
                    set.remove(subscriber);
                }
            });
        }
    }

    private void releaseInternal() {
        for (Subscription subscription : apiSubscribers.values()) {
            if (subscription == null || subscription.isUnsubscribed()) continue;
            subscription.unsubscribe();
        }
        apiSubscribers.clear();
        canceller.clear();
    }

    @NonNull
    private static synchronized Action getAction() {
        if (action == null) {
            action = new Action();
        }
        return action;
    }

    static <E> void apiSubscribe(Observable<E> observable, RestSubscriber<E> subscriber, @Nullable ActionType targetActionType, @Nullable ActionType[] cancelActionTypes) {
        Action.getAction().apiSubscribeInternal(observable, subscriber, targetActionType, cancelActionTypes);
    }

    public static void invoke(ActionType actionType) {
        Action.getAction().invokeInternal(actionType);
    }

    static boolean isRunning(ActionType actionType) {
        return Action.getAction().isRunningInternal(actionType);
    }

    public static Observable<ActionType> observable() {
        return Action.getAction().observableInternal();
    }

    public static void removeSubscriber(RestSubscriber<?> subscriber) {
        Action.getAction().removeSubscriberInternal(subscriber);
    }

    public static void release() {
        Action.getAction().releaseInternal();
    }
}

