/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.net.Uri;
import com.zoyi.channel.plugin.android.activity.photo_picker.OnPhotoClickListener;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerContract;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoDataSource;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoRepository;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.rx.Subscriber;
import java.util.ArrayList;

public class PhotoPickerPresenter
extends AbstractAdapterPresenter<PhotoPickerContract.View, PhotoPickerAdapterContract.View, PhotoPickerAdapterContract.Model>
implements PhotoPickerContract.Presenter,
OnPhotoClickListener {
    private Context context;
    private PhotoRepository photoRepository;

    @Initializer
    PhotoPickerPresenter(Context context, PhotoPickerContract.View view, PhotoPickerAdapterContract.View adapterView, PhotoPickerAdapterContract.Model adapterModel) {
        super(view, adapterView, adapterModel);
        adapterView.setOnPhotoClickListener(this);
        this.context = context;
    }

    @Override
    @Initializer
    public void init() {
        this.photoRepository = new PhotoRepository(new PhotoDataSource());
    }

    @Override
    public void fetchPhotoItems() {
        this.photoRepository.getPhotoItems(this.context, new Subscriber<ArrayList<PhotoItem>>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
                ((PhotoPickerContract.View)PhotoPickerPresenter.this.view).loadPhotoItems(new ArrayList<PhotoItem>());
            }

            public void onNext(ArrayList<PhotoItem> photoItems) {
                ((PhotoPickerContract.View)PhotoPickerPresenter.this.view).loadPhotoItems(photoItems);
                ((PhotoPickerAdapterContract.Model)PhotoPickerPresenter.this.adapterModel).setPhotoItems(photoItems);
                ((PhotoPickerContract.View)PhotoPickerPresenter.this.view).onSelectChange(((PhotoPickerAdapterContract.Model)PhotoPickerPresenter.this.adapterModel).getSelectedPaths().size());
            }
        });
    }

    @Override
    public void onPhotoClick(PhotoItem photoItem) {
        if (!((PhotoPickerAdapterContract.View)this.adapterView).onPhotoItemClick(photoItem)) {
            ((PhotoPickerContract.View)this.view).showLimitPopup();
        }
        ((PhotoPickerContract.View)this.view).onSelectChange(((PhotoPickerAdapterContract.Model)this.adapterModel).getSelectedPaths().size());
    }

    @Override
    public ArrayList<Uri> getSelectedPaths() {
        return ((PhotoPickerAdapterContract.Model)this.adapterModel).getSelectedPaths();
    }
}

