/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat3.manager.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.action.PushBotAction;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat3.listener.MessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat3.manager.chat.ChatManagerImpl;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.ChatStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

class RealChatManager
implements ChatManagerImpl {
    private String chatId;
    private Map<ContentType, Queue<SendingMessageItem>> queue;
    private Map<ContentType, SendingMessageItem> sendingItems;
    private Map<String, SendingMessageItem> failedItems;
    @Nullable
    private MessageSendListener listener;

    RealChatManager(String chatId) {
        this.chatId = chatId;
        this.queue = new HashMap<ContentType, Queue<SendingMessageItem>>();
        this.sendingItems = new HashMap<ContentType, SendingMessageItem>();
        this.failedItems = new HashMap<String, SendingMessageItem>();
        for (ContentType contentType : ContentType.values()) {
            this.queue.put(contentType, new LinkedList());
        }
    }

    @Override
    public void attachListener(@Nullable MessageSendListener listener) {
        this.listener = listener;
    }

    @Override
    public void clearListener() {
        this.listener = null;
    }

    @Override
    public void send(@Nullable SendingMessageItem item) {
        this.send(Collections.singleton(item));
    }

    @Override
    public void send(@Nullable Collection<SendingMessageItem> items) {
        if (items != null) {
            for (SendingMessageItem item : items) {
                if (item == null) continue;
                if (item.getSendingState() == SendingState.WAITING) {
                    Queue<SendingMessageItem> itemQueue = this.queue.get((Object)item.getContentType());
                    if (itemQueue == null) continue;
                    itemQueue.add(item);
                    continue;
                }
                this.failedItems.put(item.getRequestId(), item);
            }
        }
        for (ContentType contentType : ContentType.values()) {
            this.send(contentType);
        }
    }

    private void send(ContentType contentType) {
        SendingMessageItem newItem;
        if (this.sendingItems.get((Object)contentType) != null) {
            return;
        }
        Queue<SendingMessageItem> itemQueue = this.queue.get((Object)contentType);
        SendingMessageItem sendingMessageItem = newItem = itemQueue != null && itemQueue.size() > 0 ? itemQueue.poll() : null;
        if (newItem != null) {
            this.sendingItems.put(contentType, newItem);
            switch (contentType) {
                case TEXT: {
                    this.sendText(newItem);
                    break;
                }
                case FILE: {
                    this.uploadFile(newItem);
                    break;
                }
                case ACTION: {
                    this.handleAction(newItem);
                }
            }
        }
    }

    private void sendText(SendingMessageItem item) {
        ChatAction.sendTextMessage(this.chatId, item, this.createCommonSubscriber(ContentType.TEXT, item));
    }

    private void uploadFile(SendingMessageItem item) {
        ChatAction.uploadFile(this.chatId, item, this.createCommonSubscriber(ContentType.FILE, item));
    }

    private void handleAction(SendingMessageItem item) {
        String actionType = item.getActionType();
        ActionButton actionButton = item.getActionButton();
        if (actionType != null && actionButton != null) {
            block6 : switch (actionType) {
                case "userChat.solve": 
                case "userChat.close": {
                    switch (actionButton.getKey()) {
                        case "close": {
                            this.closeChat(item);
                            break block6;
                        }
                        case "like": {
                            this.reviewChat(item, "like");
                            break block6;
                        }
                        case "dislike": {
                            this.reviewChat(item, "dislike");
                            break block6;
                        }
                    }
                    this.doAction(item);
                    break;
                }
                case "keepPushBot": {
                    this.keepPushBot(item);
                    break;
                }
                case "supportBot": {
                    this.selectSupportBotStep(item);
                    break;
                }
                default: {
                    this.doAction(item);
                }
            }
        }
    }

    private void keepPushBot(SendingMessageItem item) {
        PushBotAction.keepPushBot(this.chatId, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    private void closeChat(SendingMessageItem item) {
        ChatAction.closeChat(this.chatId, item, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    private void reviewChat(SendingMessageItem item, @NonNull String review) {
        ChatAction.reviewChat(this.chatId, review, item, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    private void selectSupportBotStep(SendingMessageItem item) {
        ChatAction.selectSupportBotStep(this.chatId, item, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    private void doAction(SendingMessageItem item) {
        ChatAction.selectForm(this.chatId, item, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    private RestSubscriber<MessageWrapper> createCommonSubscriber(final ContentType contentType, final SendingMessageItem item) {
        return new RestSubscriber<MessageWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                RealChatManager.this.sendingItems.remove((Object)contentType);
                RealChatManager.this.handleFailedMessage(contentType, item);
            }

            @Override
            public void onSuccess(@NonNull MessageWrapper repo) {
                if (repo.getMessage() != null) {
                    RealChatManager.this.handleSucceedMessage(contentType, repo.getMessage());
                } else {
                    RealChatManager.this.handleFailedMessage(contentType, item);
                }
            }
        };
    }

    private void handleFailedMessage(ContentType contentType, SendingMessageItem item) {
        item.setSendingState(SendingState.FAIL);
        this.sendingItems.remove((Object)contentType);
        this.failedItems.put(item.getRequestId(), item);
        if (this.listener != null) {
            this.listener.onFail(item);
        }
        this.send(contentType);
    }

    private void handleSucceedMessage(ContentType contentType, Message message) {
        this.sendingItems.remove((Object)contentType);
        ChatStore.get().messages.add(message);
        this.send(contentType);
    }

    @Override
    public void resend(@Nullable SendingMessageItem item) {
        if (item != null && this.failedItems.containsKey(item.getRequestId())) {
            SendingMessageItem newItem = SendingMessageItem.copyContentFrom(item);
            if (this.listener != null) {
                this.listener.onResend(newItem, item);
            }
            this.failedItems.remove(item.getRequestId());
            this.send(newItem);
        }
    }

    @Override
    @NonNull
    public List<SendingMessageItem> getUnsentItems() {
        ArrayList<SendingMessageItem> items = new ArrayList<SendingMessageItem>();
        for (ContentType contentType : ContentType.values()) {
            SendingMessageItem sendingItem;
            Queue<SendingMessageItem> itemQueue = this.queue.get((Object)contentType);
            if (itemQueue != null) {
                items.addAll(itemQueue);
            }
            if ((sendingItem = this.sendingItems.get((Object)contentType)) == null) continue;
            items.add(sendingItem);
        }
        items.addAll(this.failedItems.values());
        return items;
    }

    @Override
    public void removeFailedItem(SendingMessageItem item) {
        if (item != null) {
            this.failedItems.remove(item.getRequestId());
        }
    }

    @Override
    public void release() {
        this.queue.clear();
        this.sendingItems.clear();
        this.failedItems.clear();
        this.listener = null;
    }
}

