package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.MessageAction;
import com.zoyi.channel.plugin.android.model.MessageButton;
import com.zoyi.channel.plugin.android.model.Submit;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.PersonEntity;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.util.message_format.span.GiantEmojiSpan;

import java.util.Comparator;
import java.util.List;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Message implements Entity, PersonEntity {
  private String id;
  private String channelId;
  private String chatType;
  private String chatId;
  private String personType;
  private String personId;
  private String message;
  private String messageV2;
  private String title;
  private Long createdAt;
  private String requestId;
  private File file;
  private WebPage webPage;
  private Log log;
  private SpannableStringBuilder formattedSpanMessage;
  private String formattedStringMessage;
  private List<ProfileBot> profileBot;
  private MessageAction action;
  private Submit submit;
  private String language;
  private String system;
  private List<MessageButton> buttons;

  public Message() {
  }

  public Message(String message, String personType, String personId, long createdAt) {
    this.message = message;
    this.personType = personType;
    this.personId = personId;
    this.createdAt = createdAt;
    this.formattedSpanMessage = ParseUtils.parseMessage(message);
    if (formattedSpanMessage != null) {
      this.formattedStringMessage = formattedSpanMessage.toString();
    }
  }

  @Override
  public String getId() {
    return id;
  }

  public String getChannelId() {
    return channelId;
  }

  public String getChatId() {
    return chatId;
  }

  public String getPersonType() {
    return personType;
  }

  public String getPersonId() {
    return personId;
  }

  @Override
  public boolean isOwnedBy(@Nullable String personType, @Nullable String personId) {
    return personType != null && personType.equals(this.personType) && personId != null && personId.equals(this.personId);
  }

  public String getMessage() {
    if (isDeleted()) {
      return "";
    }
    if (messageV2 != null) {
      return messageV2;
    } else {
      return message;
    }
  }

  @NonNull
  public Long getCreatedAt() {
    if (createdAt == null) {
      return TimeUtils.getCurrentTime();
    }
    return createdAt;
  }

  public String getTitle() {
    return title;
  }

  public String getRequestId() {
    return requestId;
  }

  public File getFile() {
    if (!isDeleted()) {
      return file;
    }
    return null;
  }

  public WebPage getWebPage() {
    if (!isDeleted()) {
      return webPage;
    }
    return null;
  }

  public Log getLog() {
    return log;
  }

  public SpannableStringBuilder getFormattedSpanMessage() {
    return formattedSpanMessage;
  }

  public List<ProfileBot> getProfileBot() {
    return profileBot;
  }

  public MessageAction getAction() {
    return action;
  }

  public String getLanguage() {
    return language;
  }

  public List<MessageButton> getButtons() {
    return buttons;
  }

  public void setFormattedSpanMessage(SpannableStringBuilder formattedSpanMessage) {
    this.formattedSpanMessage = formattedSpanMessage;
  }

  public void setFormattedStringMessage(String formattedStringMessage) {
    this.formattedStringMessage = formattedStringMessage;
  }

  public void clearAction() {
    this.action = null;
  }

  public boolean shouldTranslate() {
    if (isDeleted()) {
      return false;
    }

    Context context = ChannelIO.getAppContext();

    return message != null
        && context != null
        && language != null
        && !Utils.isSameLanguage(language)
        && SettingsStore.get().showTranslation.get();
  }

  public boolean isDeleted() {
    return getLog() != null && Const.DELETE_MESSAGE.equals(getLog().getAction());
  }

  public boolean hasButtons() {
    return !isDeleted() && ListUtils.hasItems(buttons);
  }

  public String getSystem() {
    return system;
  }

  public final static String CLASSNAME = "Message";
}
