package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.etc.MarginBox;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.selector2.StyleSelector;
import com.zoyi.channel.plugin.android.util.draw.Resizer;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

/**
 * Created by mika on 8/31/16.
 */
class PhotoHolder extends RecyclerView.ViewHolder implements View.OnClickListener {

  private RelativeLayout root;
  private ImageView imageView;
  private SmoothCheckBox checkBox;

  private int itemMargin;

  @Nullable
  private OnPhotoClickListener listener;

  @Nullable
  private PhotoItem photoItem;

  PhotoHolder(
      View itemView,
      int itemSize,
      int itemMargin,
      @Nullable OnPhotoClickListener listener) {
    super(itemView);

    this.itemMargin = itemMargin;
    this.listener = listener;

    root = itemView.findViewById(R.id.image_layout);
    imageView = itemView.findViewById(R.id.image_view);
    checkBox = itemView.findViewById(R.id.checkbox);

    checkBox.setOnClickListener(this);

    root.setOnClickListener(this);

    checkBox.setVisibility(View.VISIBLE);
    checkBox.setCheckedColor(StyleSelector.getBackColor());
    checkBox.setTickColor(StyleSelector.getTextColor());
    checkBox.setClickable(false);

    Resizer.size(itemView, itemSize, itemSize);
  }

  void setValue(PhotoItem photoItem, int position, boolean selected) {
    this.photoItem = photoItem;

    MarginBox marginBox = getMargin(position);

    root.setPadding(
        marginBox.getLeft(),
        marginBox.getTop(),
        marginBox.getRight(),
        marginBox.getBottom());

    checkBox.setChecked(selected);

    Glide.with(itemView.getContext())
        .load(photoItem.getUri())
        .diskCacheStrategy(DiskCacheStrategy.RESULT)
        .placeholder(R.drawable.ch_plugin_image_placeholder)
        .error(R.drawable.ch_plugin_image_placeholder)
        .into(imageView);
  }

  private MarginBox getMargin(int position) {
    if (position < Const.COLUMNS_PHOTO_PICKER) {
      return new MarginBox(itemMargin, itemMargin * 2, itemMargin, itemMargin * 2);
    }
    return new MarginBox(itemMargin, 0, itemMargin, itemMargin * 2);
  }

  private void checkboxClicked() {
    if (photoItem != null && listener != null) {
      listener.onPhotoClick(photoItem);
    }
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.image_layout || id == R.id.checkbox) {
      checkboxClicked();
    }
  }
}
