package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.etc.PushItem;

public class PopupPushView extends BasePushView {

  private TextView textPopupTitle;
  private TextView textPushBotPopupButton;

  public PopupPushView(@NonNull Context context) {
    super(context);
  }

  public PopupPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public PopupPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected int getLayoutId() {
    return R.layout.ch_plugin_view_popup;
  }

  @Override
  protected void init(Context context) {
    super.init(context);
    this.textPushBotPopupButton = root.findViewById(R.id.ch_text_popup_button);
    this.textPopupTitle = root.findViewById(R.id.ch_text_popup_title);
  }

  @Override
  public void show(PushItem pushItem) {
    super.show(pushItem);
    this.root.setOnClickListener(view -> {
    });
  }

  @Override
  public void resetView() {
    super.resetView();

    textPopupTitle.setText("");
    textPopupTitle.setVisibility(View.GONE);
  }

  @Override
  protected int getDefaultTextMaxLine() {
    return 8;
  }

  @Override
  protected int getAttachmentTextMaxLine() {
    return 5;
  }

  @Override
  protected void bindTitle(PushItem pushItem) {
    if (textPopupTitle != null) {
      if (pushItem.getTitle() != null && !pushItem.getTitle().isEmpty()) {
        textPopupTitle.setVisibility(View.VISIBLE);
        textPopupTitle.setText(pushItem.getTitle());
      } else {
        textPopupTitle.setVisibility(View.GONE);
      }
    }
  }

  @Override
  protected void bindContent(PushItem pushItem) {
    if (textPopupMessage != null) {
      textPopupMessage.setMaxLines(getDefaultTextMaxLine());
      textPopupMessage.setText(pushItem.getFormattedSpanMessage());
    }
  }

  @Override
  protected void bindButton() {
    if (item != null && item.getButtonTitle() != null) {
      if (textPopupMessage != null) {
        textPopupMessage.setMaxLines(getAttachmentTextMaxLine());
      }

      buttonPushBotPopupButton.setVisibility(VISIBLE);
      textPushBotPopupButton.setText(item.getButtonTitle());
    } else {
      if (textPopupMessage != null) {
        textPopupMessage.setMaxLines(getDefaultTextMaxLine());
      }
      buttonPushBotPopupButton.setVisibility(GONE);
    }
  }
}
