package com.zoyi.channel.plugin.android.selector2;

import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.etc.ChatPushItem;
import com.zoyi.channel.plugin.android.model.etc.PushItem;
import com.zoyi.channel.plugin.android.model.rest.PushBot;
import com.zoyi.channel.plugin.android.store2.InAppPushStore;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder2;
import com.zoyi.channel.plugin.android.store2.state.BooleanState;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.rx.functions.Action1;

public class PushSelector {

  public static Binder bindPopup(Context context, Action1<PushItem> action1) {
    State<PushItem> pushItemState = InAppPushStore.get().pushItem;
    BooleanState hideInAppPushState = SettingsStore.get().hideDefaultInAppPush;

    return new Binder2<>(pushItemState, hideInAppPushState).bind((pushItem, hideInAppPush) -> {
      if (!hideInAppPush && pushItem instanceof ChatPushItem) {
        action1.call(pushItem);
      } else if (pushItem instanceof PushBotItem && ((PushBotItem) pushItem).isActivatedIn(context)) {
        action1.call(pushItem);
      } else {
        action1.call(null);
      }
    });
  }

  public static boolean canTryReach(@Nullable PushBot pushBot) {
    return pushBot != null && pushBot.getId() != null && PushBotStore.get().pushBots.get(pushBot.getId()) == null;
  }
}
