package com.zoyi.channel.plugin.android.action;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;

public class PushBotAction {

  public static void createPushBotUserChat(@Nullable String pushBotId, RestSubscriber<UserChatWrapper> subscriber) {
    if (pushBotId != null) {
      Api.createPushBotUserChat(pushBotId)
          .runBy(ActionType.CREATE_USER_CHAT)
          .cancelBy(ActionType.SHUTDOWN)
          .run(subscriber);
    }
  }

  public static void keepPushBot(@Nullable String chatId, RestSubscriber<MessageWrapper> subscriber) {
    if (chatId != null) {
      Api.keepPushBot(chatId)
          .runBy(ActionType.KEEP_PUSH_BOT)
          .cancelBy(ActionType.SHUTDOWN)
          .run(subscriber);
    }
  }
}
