/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.channel.plugin.android.model.rest.WorkingTime;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public class ChannelUtils {
    private static final long MINUTES_TO_MILLISECONDS = 60000L;
    private static final int DAY_IN_MINUTES = 1440;

    public static boolean isChannelPluginActivity(Context context) {
        return context instanceof BaseActivity2;
    }

    public static boolean isSameActivity(@Nullable Context target, @Nullable String className, int hashCode) {
        return target != null && CompareUtils.isSame(target.getClass().getCanonicalName(), className) && target.hashCode() == hashCode;
    }

    public static int getMinutesLeftToWork(@Nullable Channel channel, @Nullable Long timestamp) {
        if (channel == null || timestamp == null || timestamp == 0L) {
            return -1;
        }
        if ("always".equals(channel.getWorkingType())) {
            return 0;
        }
        if ("never".equals(channel.getWorkingType())) {
            return -1;
        }
        WorkingTime workingTime = channel.getWorkingTime();
        if (workingTime == null || !workingTime.isValid()) {
            return 0;
        }
        long utcOffsetMilliseconds = channel.getUtcOffsetMinutes() * 60000L;
        long now = timestamp + utcOffsetMilliseconds;
        Calendar calendar = Calendar.getInstance(new SimpleTimeZone(0, "UTC"));
        calendar.setTimeInMillis(now);
        int weekday = calendar.get(7);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int totalRemainMinutes = 0;
        for (int daysDelta = 0; daysDelta <= 7; ++daysDelta) {
            int nowMinutes = daysDelta == 0 ? hours * 60 + minutes : 0;
            int targetWeekday = (weekday - 1 + daysDelta) % 7 + 1;
            int remainMinutes = ChannelUtils.getRemainingMinuteForWeekday(workingTime.getWeekdayTimeRange(targetWeekday), channel.getLunchTime(), nowMinutes);
            if (remainMinutes == -1) {
                totalRemainMinutes += 1440 - nowMinutes;
                continue;
            }
            totalRemainMinutes += remainMinutes;
            break;
        }
        return totalRemainMinutes;
    }

    private static int getRemainingMinuteForWeekday(@Nullable TimeRange weekday, @Nullable TimeRange lunch, int nowMinutes) {
        if (weekday == null || !weekday.isValid()) {
            return -1;
        }
        ArrayList<TimeRange> workingRanges = new ArrayList<TimeRange>();
        if (lunch != null && lunch.isValid()) {
            TimeRange restTime = new TimeRange(Math.max(weekday.getFrom(), lunch.getFrom()), Math.min(weekday.getTo(), lunch.getTo()));
            if (restTime.isValid()) {
                if (weekday.getFrom() < restTime.getFrom()) {
                    workingRanges.add(new TimeRange(weekday.getFrom(), restTime.getFrom()));
                }
                if (restTime.getTo() < weekday.getTo()) {
                    workingRanges.add(new TimeRange(restTime.getTo(), weekday.getTo()));
                }
            } else {
                workingRanges.add(weekday);
            }
        } else {
            workingRanges.add(weekday);
        }
        for (TimeRange timeRange : workingRanges) {
            if (nowMinutes < timeRange.getFrom()) {
                return timeRange.getFrom() - nowMinutes;
            }
            if (nowMinutes > timeRange.getTo()) continue;
            return 0;
        }
        return -1;
    }
}

